% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_smoothest.R
\name{fsl_smoothest}
\alias{fsl_smoothest}
\title{Smoothness Estimation using \code{smoothest}}
\usage{
fsl_smoothest(file, residual_image, z_image, dof = NULL, opts = "",
  verbose = TRUE, ...)
}
\arguments{
\item{file}{filename of input brain mask}

\item{residual_image}{4d residual image.  If specified, then
\code{dof} must be specified.}

\item{z_image}{z-statistic image.  Cannot be specified if 
\code{residual_image} is specified}

\item{dof}{number of degrees of freedom}

\item{opts}{(character) operations to be passed to \code{smoothest}}

\item{verbose}{(logical) print out command before running}

\item{...}{additional arguments to pass to \code{\link{fslcmd}}}
}
\value{
An output of smoothness estimate
}
\description{
Smoothness Estimation using \code{smoothest}
}
\examples{
if (have_fsl()) {
file = mni_fname(mm = 2, brain = TRUE, mask = TRUE)
img = mni_img(mm = 2, brain = TRUE, mask = FALSE)
mask = mni_img(mm = 2, brain = TRUE, mask = TRUE)
img = zscore_img(img = img, mask = mask)
est = fsl_smoothest(file = file, z_image = img)
}
}
