% Generated by roxygen2 (4.0.1): do not edit by hand
\name{fslthresh}
\alias{fslthresh}
\title{Threshold an image}
\usage{
fslthresh(file, outfile = NULL, thresh = 0, uthresh = NULL,
  retimg = FALSE, reorient = FALSE, intern = TRUE, opts = "", ...)
}
\arguments{
\item{file}{(character) filename of image to be thresholded}

\item{outfile}{(character) name of resultant thresholded file}

\item{thresh}{(numeric) threshold (anything below set to 0)}

\item{uthresh}{(numeric) upper threshold (anything above set to 0)}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readNIfTI}}.}

\item{intern}{(logical) pass to \code{\link{system}}}

\item{opts}{(character) additional options to be passed to fslmaths}

\item{...}{additional arguments passed to \code{\link{readNIfTI}}.}
}
\value{
character or logical depending on intern
}
\description{
This function calls \code{fslmaths -thr -uthr} to threshold an image
and either saves the image or returns an object of class nifti
}
\examples{
if (have.fsl()){
system.time({
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100),
datatype = convert.datatype()$FLOAT32, cal.min = min(x),
cal.max = max(x), pixdim = rep(1, 4))
thresh = fslthresh(img, thresh=0, uthresh = 2, retimg=TRUE)
})
}
}

