% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs3-variables}
\alias{bs3-variables}
\alias{bs_vars}
\alias{bs_vars_global}
\alias{bs_vars_color}
\alias{bs_vars_navbar}
\alias{bs_vars_nav}
\alias{bs_vars_font}
\alias{bs_vars_wells}
\alias{bs_vars_state}
\alias{bs_vars_input}
\alias{bs_vars_alert}
\alias{bs_vars_progress}
\alias{bs_vars_panel}
\alias{bs_vars_modal}
\alias{bs_vars_button}
\alias{bs_vars_dropdown}
\alias{bs_vars_pills}
\alias{bs_vars_tabs}
\alias{bs_vars_badge}
\alias{bs_vars_component}
\alias{bs_vars_table}
\title{Bootstrap custom variables}
\usage{
bs_vars(...)

bs_vars_global(
  body_bg = NULL,
  text_color = NULL,
  link_color = NULL,
  link_hover_color = NULL,
  line_height_base = NULL,
  grid_columns = NULL,
  grid_gutter_width = NULL,
  border_radius_base = NULL
)

bs_vars_color(
  brand_primary = NULL,
  brand_success = NULL,
  brand_info = NULL,
  brand_warning = NULL,
  brand_danger = NULL,
  gray_base = NULL,
  gray_darker = NULL,
  gray_dark = NULL,
  gray = NULL,
  gray_light = NULL,
  gray_lighter = NULL
)

bs_vars_navbar(
  height = NULL,
  margin_bottom = NULL,
  border_radius = NULL,
  padding_horizontal = NULL,
  padding_vertical = NULL,
  collapse_max_height = NULL,
  default_color = NULL,
  default_bg = NULL,
  default_border = NULL,
  default_link_color = NULL,
  default_link_active_color = NULL,
  default_link_active_bg = NULL,
  default_link_hover_color = NULL,
  default_link_hover_bg = NULL,
  inverse_color = NULL,
  inverse_bg = NULL,
  inverse_border = NULL,
  inverse_link_color = NULL,
  inverse_link_active_color = NULL,
  inverse_link_active_bg = NULL,
  inverse_link_hover_color = NULL,
  inverse_link_hover_bg = NULL
)

bs_vars_nav(
  link_padding = NULL,
  link_hover_bg = NULL,
  disabled_link_color = NULL,
  disabled_link_hover_color = NULL
)

bs_vars_font(
  family_sans_serif = NULL,
  size_base = NULL,
  size_large = NULL,
  size_small = NULL,
  size_h1 = NULL,
  size_h2 = NULL,
  size_h3 = NULL,
  size_h4 = NULL,
  size_h5 = NULL,
  size_h6 = NULL
)

bs_vars_wells(bg = NULL, border = NULL)

bs_vars_state(
  success_text = NULL,
  success_bg = NULL,
  success_border = NULL,
  info_text = NULL,
  info_bg = NULL,
  info_border = NULL,
  warning_text = NULL,
  warning_bg = NULL,
  warning_border = NULL,
  danger_text = NULL,
  danger_bg = NULL,
  danger_border = NULL
)

bs_vars_input(
  bg = NULL,
  color = NULL,
  border = NULL,
  border_radius = NULL,
  color_placeholder = NULL,
  group_addon_bg = NULL,
  border_focus = NULL,
  bg_disabled = NULL
)

bs_vars_alert(
  padding = NULL,
  border_radius = NULL,
  link_font_weight = NULL,
  success_text = NULL,
  success_bg = NULL,
  success_border = NULL,
  info_text = NULL,
  info_bg = NULL,
  info_border = NULL,
  warning_text = NULL,
  warning_bg = NULL,
  warning_border = NULL,
  danger_text = NULL,
  danger_bg = NULL,
  danger_border = NULL
)

bs_vars_progress(
  bg = NULL,
  bar_color = NULL,
  border_radius = NULL,
  bar_bg = NULL,
  bar_success_bg = NULL,
  bar_warning_bg = NULL,
  bar_danger_bg = NULL,
  bar_info_bg = NULL
)

bs_vars_panel(
  bg = NULL,
  body_padding = NULL,
  heading_padding = NULL,
  footer_padding = NULL,
  border_radius = NULL,
  inner_border = NULL,
  footer_bg = NULL,
  default_text = NULL,
  default_border = NULL,
  default_heading_bg = NULL,
  primary_text = NULL,
  primary_border = NULL,
  primary_heading_bg = NULL,
  success_text = NULL,
  success_border = NULL,
  success_heading_bg = NULL,
  info_text = NULL,
  info_border = NULL,
  info_heading_bg = NULL,
  warning_text = NULL,
  warning_border = NULL,
  warning_heading_bg = NULL,
  danger_text = NULL,
  danger_border = NULL,
  danger_heading_bg = NULL
)

bs_vars_modal(
  md = NULL,
  lg = NULL,
  sm = NULL,
  inner_padding = NULL,
  title_padding = NULL,
  title_line_height = NULL,
  content_bg = NULL,
  content_border_color = NULL,
  content_fallback_border_color = NULL,
  backdrop_bg = NULL,
  backdrop_opacity = NULL,
  header_border_color = NULL,
  footer_border_color = NULL
)

bs_vars_button(
  font_weight = NULL,
  default_color = NULL,
  default_bg = NULL,
  default_border = NULL,
  primary_color = NULL,
  primary_bg = NULL,
  primary_border = NULL,
  success_color = NULL,
  success_bg = NULL,
  success_border = NULL,
  info_color = NULL,
  info_bg = NULL,
  info_border = NULL,
  warning_color = NULL,
  warning_bg = NULL,
  warning_border = NULL,
  danger_color = NULL,
  danger_bg = NULL,
  danger_border = NULL,
  link_disabled_color = NULL,
  border_radius_base = NULL,
  border_radius_large = NULL,
  border_radius_small = NULL
)

bs_vars_dropdown(
  bg = NULL,
  border = NULL,
  fallback_border = NULL,
  divider_bg = NULL,
  link_color = NULL,
  link_hover_color = NULL,
  link_hover_bg = NULL,
  link_active_color = NULL,
  link_active_bg = NULL,
  link_disabled_color = NULL,
  header_color = NULL
)

bs_vars_pills(
  border_radius = NULL,
  active_link_hover_bg = NULL,
  active_link_hover_color = NULL
)

bs_vars_tabs(
  border_color = NULL,
  link_hover_border_color = NULL,
  active_link_hover_bg = NULL,
  active_link_hover_color = NULL,
  active_link_hover_border_color = NULL,
  justified_link_border_color = NULL,
  justified_active_link_border_color = NULL
)

bs_vars_badge(
  color = NULL,
  bg = NULL,
  link_hover_color = NULL,
  active_color = NULL,
  active_bg = NULL,
  font_weight = NULL,
  line_height = NULL,
  border_radius = NULL
)

bs_vars_component(
  padding_base_vertical = NULL,
  padding_base_horizontal = NULL,
  padding_large_vertical = NULL,
  padding_large_horizontal = NULL,
  padding_small_vertical = NULL,
  padding_small_horizontal = NULL,
  padding_xs_vertical = NULL,
  padding_xs_horizontal = NULL,
  line_height_large = NULL,
  line_height_small = NULL,
  border_radius_base = NULL,
  border_radius_large = NULL,
  border_radius_small = NULL,
  component_active_color = NULL,
  component_active_bg = NULL,
  caret_width_base = NULL,
  caret_width_large = NULL
)

bs_vars_table(
  cell_padding = NULL,
  condensed_cell_padding = NULL,
  bg = NULL,
  bg_accent = NULL,
  bg_hover = NULL,
  bg_active = NULL,
  border_color = NULL
)
}
\arguments{
\item{...}{Variables to use, under the form \code{body_bg = "#FFF"} or \code{"body-bg" = "#FFF"}.}

\item{body_bg}{Background color for the body.}

\item{text_color}{Global text color on body.}

\item{link_color}{Dropdown link text color.}

\item{link_hover_color}{Linked badge text color on hover.}

\item{line_height_base}{Unit-less \code{line-height} for use in components like buttons.}

\item{grid_columns}{Number of columns in the grid, e.g. in \code{\link[shiny:fluidPage]{shiny::fluidRow(shiny::column(...))}}.}

\item{grid_gutter_width}{Padding between columns. Gets divided in half for the left and right.}

\item{border_radius_base}{Base border radius.}

\item{brand_primary}{Primary color, default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#337ab7")}.}

\item{brand_success}{Success color, default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#5cb85c")}.}

\item{brand_info}{Info color, default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#5bc0de")}.}

\item{brand_warning}{Warning color, default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#f0ad4e")}.}

\item{brand_danger}{Danger color, default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#d9534f")}.}

\item{gray_base}{Base gray color.}

\item{gray_darker}{Darker gray color.}

\item{gray_dark}{Dark gray color.}

\item{gray}{Gray color.}

\item{gray_light}{Light gray color.}

\item{gray_lighter}{Lighter gray color.}

\item{height}{Height of the navbar, e.g. \code{"50px"} (the default in Bootstrap).}

\item{margin_bottom}{Bottom margin of navbar.}

\item{border_radius}{Border radius.}

\item{padding_horizontal}{Horizontal padding.}

\item{padding_vertical}{= Vertical padding.}

\item{collapse_max_height}{Max height when collapsed.}

\item{default_color}{Text color for default buttons.}

\item{default_bg}{Background color for default buttons.}

\item{default_border}{Border color for default buttons.}

\item{default_link_color}{Link color.}

\item{default_link_active_color}{Color for active link (selected tab).}

\item{default_link_active_bg}{Background color for active link (selected tab).}

\item{default_link_hover_color}{Color of links when hovered.}

\item{default_link_hover_bg}{Background color of links when hovered.}

\item{inverse_color}{Color of text for inverted navbar.}

\item{inverse_bg}{Background color for inverted navbar.}

\item{inverse_border}{Border color for inverted navbar.}

\item{inverse_link_color}{Link color for inverted navbar.}

\item{inverse_link_active_color}{Color for active link (selected tab) for inverted navbar.}

\item{inverse_link_active_bg}{Background color for active link (selected tab) for inverted navbar.}

\item{inverse_link_hover_color}{Color of links when hovered for inverted navbar.}

\item{inverse_link_hover_bg}{Background color of links when hovered for inverted navbar.}

\item{link_padding}{Padding for links (tabset's titles).}

\item{link_hover_bg}{Hover background for dropdown links.}

\item{disabled_link_color}{Disabled link color.}

\item{disabled_link_hover_color}{Disabled link hover color.}

\item{family_sans_serif}{Font family to use.}

\item{size_base}{Size of base font, e.g. normal text, default in Bootstrap is \code{"15px"}.}

\item{size_large}{Size of large text.}

\item{size_small}{Size of small text.}

\item{size_h1}{Size of h1 tags.}

\item{size_h2}{Size of h2 tags.}

\item{size_h3}{Size of h3 tags.}

\item{size_h4}{Size of h4 tags.}

\item{size_h5}{Size of h5 tags.}

\item{size_h6}{Size of h6 tags.}

\item{bg}{Background color.}

\item{border}{Dropdown menu border-color.}

\item{success_text}{Text color for success status.}

\item{success_bg}{Background color for success buttons.}

\item{success_border}{Border color for success buttons.}

\item{info_text}{Text color for info status.}

\item{info_bg}{Background color for info buttons.}

\item{info_border}{Border color for info buttons.}

\item{warning_text}{Text color for warning status.}

\item{warning_bg}{Background color for warning buttons.}

\item{warning_border}{Border color for warning buttons.}

\item{danger_text}{Text color for danger status.}

\item{danger_bg}{Background color for danger buttons.}

\item{danger_border}{Border color for danger buttons.}

\item{color}{Text color.}

\item{color_placeholder}{Text color of placeholder.}

\item{group_addon_bg}{Background color of addons.}

\item{border_focus}{Color of border when focused.}

\item{bg_disabled}{Background color for disabled input.}

\item{padding}{Padding for alerts.}

\item{link_font_weight}{Font weight for links in alerts.}

\item{bar_color}{Progress bar text color}

\item{bar_bg}{Default progress bar color.}

\item{bar_success_bg}{Success progress bar color.}

\item{bar_warning_bg}{Warning progress bar color.}

\item{bar_danger_bg}{Danger progress bar color.}

\item{bar_info_bg}{Info progress bar color.}

\item{body_padding}{Panel body padding.}

\item{heading_padding}{Panel heading padding.}

\item{footer_padding}{Panel footer padding.}

\item{inner_border}{Border color for inner elements in panel.}

\item{footer_bg}{Panel footer background color.}

\item{default_text}{Default color for text.}

\item{default_heading_bg}{Default background color for panel heading.}

\item{primary_text}{Text color for primary status.}

\item{primary_border}{Border color for primary buttons.}

\item{primary_heading_bg}{Heading background color for primary status.}

\item{success_heading_bg}{Heading background color for success status.}

\item{info_heading_bg}{Heading background color for info status.}

\item{warning_heading_bg}{Heading background color for warning status.}

\item{danger_heading_bg}{Heading background color for danger status.}

\item{md}{Size in pixel for medium modal, e.g. \code{modalDialog(size = "m")}.}

\item{lg}{Size in pixel for large modal, e.g. \code{modalDialog(size = "l")}.}

\item{sm}{Size in pixel for small modal, e.g. \code{modalDialog(size = "s")}.}

\item{inner_padding}{Padding applied to the modal body.}

\item{title_padding}{Padding applied to the modal title.}

\item{title_line_height}{Modal title line-height.}

\item{content_bg}{Background color of modal content area.}

\item{content_border_color}{Modal content border color.}

\item{content_fallback_border_color}{Modal content border color (for IE8).}

\item{backdrop_bg}{Modal backdrop background color.}

\item{backdrop_opacity}{Modal backdrop opacity.}

\item{header_border_color}{Modal header border color.}

\item{footer_border_color}{Modal footer border color.}

\item{font_weight}{Font weight, e.g. : \code{"bold"}.}

\item{primary_color}{Text color for primary buttons.}

\item{primary_bg}{Background color for primary buttons.}

\item{success_color}{Text color for success buttons.}

\item{info_color}{Text color for info buttons.}

\item{warning_color}{Text color for warning buttons.}

\item{danger_color}{Text color for danger buttons.}

\item{link_disabled_color}{Disabled dropdown menu item background color.}

\item{border_radius_large}{Large border radius.}

\item{border_radius_small}{Small border radius.}

\item{fallback_border}{Dropdown menu border-color (for IE8).}

\item{divider_bg}{Divider color for between dropdown items.}

\item{link_active_color}{Active dropdown menu item text color.}

\item{link_active_bg}{Active dropdown menu item background color.}

\item{header_color}{Text color for headers within dropdown menus.}

\item{active_link_hover_bg}{Active link hover background color.}

\item{active_link_hover_color}{Active link hover color.}

\item{border_color}{Border color.}

\item{link_hover_border_color}{Link hover color.}

\item{active_link_hover_border_color}{Active link hover border color.}

\item{justified_link_border_color}{Justified link border color.}

\item{justified_active_link_border_color}{Justified active link border color.}

\item{active_color}{Badge text color in active nav link.}

\item{active_bg}{Badge background color in active nav link.}

\item{line_height}{Line height.}

\item{padding_base_vertical}{Vertical base padding.}

\item{padding_base_horizontal}{Horizontal base padding.}

\item{padding_large_vertical}{Vertical large padding.}

\item{padding_large_horizontal}{Horizontal large padding.}

\item{padding_small_vertical}{Vertical small padding.}

\item{padding_small_horizontal}{Horizontal small padding.}

\item{padding_xs_vertical}{Vertical extra small padding.}

\item{padding_xs_horizontal}{Horizontal extra small padding.}

\item{line_height_large}{Line height for large elements.}

\item{line_height_small}{Line height for small elements.}

\item{component_active_color}{Color for active components.}

\item{component_active_bg}{Background color for active components.}

\item{caret_width_base}{Width for caret.}

\item{caret_width_large}{Widget for large caret.}

\item{cell_padding}{Cell padding.}

\item{condensed_cell_padding}{Cell padding when using condensed table.}

\item{bg_accent}{Background color used in striped table.}

\item{bg_hover}{Background color used when hovering the table with the mouse.}

\item{bg_active}{Background color when row is selected.}
}
\value{
a \code{list} that can be used in \code{\link[=create_theme]{create_theme()}}.
}
\description{
Use any Bootstrap variables to customize a \code{shiny} theme.
}
\note{
For a full list of available variables, use \code{\link[=search_vars_bs]{search_vars_bs()}}.
}
\examples{
bs_vars(body_bg = "#FFF")

bs_vars("body-bg" = "#FFF")
}
