% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_table}
\alias{bs_vars_table}
\title{Bootstrap table variables}
\usage{
bs_vars_table(
  cell_padding = NULL,
  condensed_cell_padding = NULL,
  bg = NULL,
  bg_accent = NULL,
  bg_hover = NULL,
  bg_active = NULL,
  border_color = NULL
)
}
\arguments{
\item{cell_padding}{Cell padding.}

\item{condensed_cell_padding}{Cell padding when using condensed table.}

\item{bg}{Background color.}

\item{bg_accent}{Background color used in striped table.}

\item{bg_hover}{Background color used when hovering the table with the mouse.}

\item{bg_active}{Background color when row is selected.}

\item{border_color}{Border color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 table (produced ever by \code{\link[shiny:renderTable]{shiny::renderTable}}
 or by \code{\link[shiny:renderDataTable]{shiny::renderDataTable}} and DT equivalent)
 in Bootstrap and Bootswatch themes.
}
\examples{

bs_vars_table(
  bg_accent = "lightblue",
  bg_hover = "firebrick"
)


if (interactive()) {
  library(shiny)
  library(fresh)

  ui <- fluidPage(

    use_theme(create_theme(
      theme = "default",
      bs_vars_table(
        bg_accent = "lightblue",
        bg_hover = "firebrick"
      )
    )),

    tags$h1("Tables"),
    fluidRow(
      column(
        width = 6,
        tableOutput("table")
      ),
      column(
        width = 6,
        dataTableOutput("datatable")
      )
    )
  )

  server <- function(input, output, session) {

    output$table <- renderTable(
      head(iris), striped = TRUE, hover = TRUE
    )

    output$datatable <- renderDataTable({
      head(mtcars)
    })

  }

  shinyApp(ui, server)
}
}
