% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/speclagreg.K.R
\name{speclagreg.K}
\alias{speclagreg.K}
\title{Determine the subspace dimension for inversion in \code{\link{speclagreg}}}
\usage{
speclagreg.K(X, Y, lags = 0:0, freq = NULL, p = 10, q = 10,
  weights = "Bartlett")
}
\arguments{
\item{X}{first process}

\item{Y}{second process, if null then autocovariance of X is computed}

\item{lags}{which \eqn{A_k} should be estimated}

\item{freq}{grid of frequencies for computation as in \code{\link{fourier.transform}}}

\item{p}{window size for estimation of spectral density of X}

\item{q}{window size for estimation of spectral density of Y and X}

\item{weights}{as in \code{\link{spectral.density}}}
}
\value{
Heursiticaly determined subspace size
}
\description{
Determine the subspace dimension for the frequency-wise operator inversion in the
estimation of regression coefficients
}
\examples{
n = 100
d = 5
X = rar(n,d=d,Psi=matrix(0,d,d))  			# independent d-dim variables
w = 0.4
Y = w*X + (1-w)*rar(n,d=d,Psi=matrix(0,d,d))	# independent d-dim variables
K = speclagreg.K(X, Y, lags=-2:2)
}
\seealso{
\code{\link{linproc}}
}

