% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fr_field.R
\name{as_fr_field}
\alias{as_fr_field}
\title{Coerce \code{character}, \code{factor}, \code{numeric}, \code{logical}, and \code{Date}
vectors into \code{\link[=fr-package]{fr_field}} objects}
\usage{
as_fr_field(x, ...)
}
\arguments{
\item{x}{a character, factor, numeric, integer, logical, or Date vector}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> required (\code{name}) and optional (\code{title}, \code{description}) \href{https://specs.frictionlessdata.io/table-schema/#field-descriptors}{field descriptors})}
}
\value{
a \link[=fr-package]{fr_field} object
}
\description{
The supported classes of \code{R} objects are converted to the corresponding frictionless \code{type}:\tabular{ll}{
   \strong{\code{R} class} \tab \strong{\code{fr} type} \cr
   \code{character()} \tab \code{string} \cr
   \code{factor()} \tab \code{string} (with \code{enum(constraints = levels(x))}) \cr
   \code{numeric()}, \code{integer()} \tab \code{number} \cr
   \code{logical()} \tab \code{boolean} \cr
   \code{Date} \tab \code{date} \cr
}
}
\examples{
as_fr_field(1:10, "example_integer") # -> frictionless number
as_fr_field((1:10) * 0.1, "example_double") # -> frictionless number
as_fr_field(letters, "example_character") # -> frictionless string
as_fr_field(factor(letters), "example_factor") # -> frictionless string with enum constraints
as_fr_field(c(TRUE, FALSE, TRUE), "example_logical") # -> frictionless boolean
as_fr_field(as.Date(c("2023-04-23", "2004-12-31")), "example_date") # -> frictionless date
}
