% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscfuns.R
\name{setFplot_page}
\alias{setFplot_page}
\alias{getFplot_page}
\title{Sets the target page size for figure exporting}
\usage{
setFplot_page(
  page = "us",
  margins = "normal",
  units = "tw",
  pt = 10,
  w2h = 1.75,
  reset = FALSE
)

getFplot_page()
}
\arguments{
\item{page}{What is the page size of the document? Can be equal to "us" (for US letter, the default) or "a4". Can also be a numeric vector of length 2 giving the width and the height of the page in **inches**. Or can be a character string of the type: \code{"8.5in,11in"} where the width and height are separated with a comma, note that only centimeters (cm), inches (in) and pixels (px) are accepted as units--further: you can use the unit only once.}

\item{margins}{The bottom/left/top/right margins of the page. This is used to obtain the dimension of the body of the text. Can be equal to "normal" (default, which corresponds to 2cm/2.5cm/2cm/2.5cm), or to "thin" (1.5/1/1/1cm). Can be a numeric vector of length 1: then all margins are the same given size in **inches**. Can also be a numeric vector of length 2 or 4: 2 means first bottom/top margins, then left/right margins; 4 is bottom/left/top/right margins, in inches. Last, it can be a character vector of the type \code{"2,2.5,2,2.5cm"} with the margins separated by a comma or a slash, and at least one unit appearing: either \code{cm}, \code{in} or \code{px}.}

\item{units}{The default units when using the functions \code{\link[fplot]{pdf_fit}}, \code{\link[fplot]{png_fit}}, etc. Defaults to \code{"tw"} (text width) which is a fraction of the size of the text. Alternatives can be \code{"pw"} (page width), and \code{"in"}, \code{"cm"}, \code{"px"}.}

\item{pt}{The size of the text, in pt, once the figure is inserted in your final document. The default is 10. This means that all text appearing in the plot with \code{cex = 1} will appear with 10pt-sized fonts in your document.}

\item{w2h}{Numeric scalar. Used to determine the height of the figure based on the width. By default it is equal to \code{1.75} which means that the graph will be 1.75 larger than tall. Note that when argument \code{sideways = TRUE}, the default for the height becomes \code{90\%}.}

\item{reset}{Logical, default is \code{FALSE}. Whether arguments should be reset to default before applying modifications.}
}
\description{
Tha package \code{fplot} offers some functions (e.g. \code{\link[fplot]{pdf_fit}} or \code{\link[fplot]{png_fit}}) to export figures, with a guarantee to obtain the desired point size for the plotting text. The function \code{setFplot_page} sets the target page size (once and for all). This is important for the accuracy of the export, although the default values should be working well most of the time.
}
\examples{

#
# How to set the page size
#

# All examples below provide the same page size
setFplot_page(page = "us")
setFplot_page(page = "8.5in, 11in")
setFplot_page(page = "8.5/11in")
setFplot_page(page = c(8.5, 11))

# All examples below provide the same margins
setFplot_page(margins = "normal")
setFplot_page(margins = "2cm, 2.5cm, 2cm, 2.5cm")
setFplot_page(margins = "2/2.5/2/2.5cm")
setFplot_page(margins = c(2, 2.5) / 2.54) # cm to in
setFplot_page(margins = c(2, 2.5, 2, 2.5) / 2.54)

}
\seealso{
Exporting functions: \code{\link[fplot]{pdf_fit}}, \code{\link[fplot]{png_fit}}. The function closing the connection and showing the obtained graph in the viewer: \code{\link[fplot]{fit.off}}.
}
