% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{scatter}
\alias{scatter}
\title{Scatterplot with information on the errors between x and y.}
\usage{
scatter(obs, preds, vars, info = TRUE)
}
\arguments{
\item{obs}{A vector of observed values}

\item{preds}{A vector of predicted values}

\item{vars}{Optional vector indicating different variables}

\item{info}{A logical value indicating whether information on count, R2, bias and RMSE should be added to the plot}
}
\value{
A ggplot2 object or a list of ggplot2 objects (one per variable)
}
\description{
Scatterplot between a vector of observed data and a vector of predicted data with information on the errors between them.
}
\details{
Accuracy metrics are calculated from \code{\link[foster]{accuracy}}
}
\examples{
# kNN_preds is a data frame obtained from foster::trainNN
# It contains predictions and observations of the trained kNN model
load(system.file("extdata/examples/kNN_preds.RData",package="foster"))

scatter(obs = kNN_preds$obs,
        preds = kNN_preds$preds,
        vars = kNN_preds$variable)
}
\seealso{
\code{\link[foster]{accuracy}}
}
