% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingPersonLR.R
\name{missingPersonLR}
\alias{missingPersonLR}
\title{Likelihood ratio calculation for missing person identification}
\usage{
missingPersonLR(reference, missing, poi = NULL, verbose = TRUE, ...)
}
\arguments{
\item{reference}{A \code{ped} object with attached markers.}

\item{missing}{The ID label of the missing member of \code{reference}.}

\item{poi}{A \code{singleton} object, or NULL. If NULL, and \code{missing} is
genotyped, this data is extracted and used as \code{poi}.}

\item{verbose}{A logical.}

\item{...}{Optional parameters to be passed onto \code{\link[=kinshipLR]{kinshipLR()}}.}
}
\value{
The \code{LRresult} object returned by \code{\link[=kinshipLR]{kinshipLR()}}, but without the
trivial \code{H2:H2} comparison.
}
\description{
This is a wrapper function for \code{\link[=kinshipLR]{kinshipLR()}} for the special case of missing
person identification. A person of interest (POI) is matched against a
reference dataset containing genotypes of relatives of the missing person.
}
\examples{
#------------------------------------------------
# Example: Identification of a missing grandchild
#------------------------------------------------

# Reference pedigree with missing grandchild (MP)
x = linearPed(2) |> relabel(old = 5, new = "MP")

# Database with 5 STR markers
db = NorwegianFrequencies[1:5]

# Simulate reference data for grandmother and MP (5 STR markers)
x = profileSim(x, markers = db, ids = c(2, "MP"), seed = 2509)

# Compute LR
lr = missingPersonLR(x, missing = "MP")
lr
lr$LRperMarker

}
