% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_math.R
\name{modify_formula}
\alias{modify_formula}
\title{Modify a formula by finding some part of it and replacing it with a new
value.}
\usage{
modify_formula(formula, find, replace, add_parens = FALSE)
}
\arguments{
\item{formula}{The formula to modify (may also be a call)}

\item{find}{A call or name (or list thereof) to search for within the formula}

\item{replace}{A call or name (or list thereof) to replace the \code{find}
values}

\item{add_parens}{Add parentheses if \code{replace} is not a name or if it is
not already something in parentheses?}
}
\value{
\code{formula} modified
}
\description{
Modify a formula by finding some part of it and replacing it with a new
value.
}
\details{
Replacement occurs at the first match, so if the replacement list
  would modify something in the find list, that change will not occur (make
  two calls to the function for that effect).  See the "Replacement is not
  sequential" examples below.

  A special call can be used to expand a formula.  If an expansion of
  arguments is desired to change a single function argument to multiple
  arguments, `formulops_expand()` can be used.  (See the examples.)
}
\examples{
modify_formula(a~b, find=quote(a), replace=quote(c))
modify_formula(a~b, find=quote(a), replace=quote(c+d))
modify_formula(a~b/c, find=quote(b/c), replace=quote(d))
# Replacement is not sequential
modify_formula(a~b/c, find=list(quote(b/c), quote(d)), replace=list(quote(d), quote(e)))
modify_formula(a~b/c+d, find=list(quote(b/c), quote(d)), replace=list(quote(d), quote(e)))
# Expanding arguments to functions is possible
modify_formula(a~b(c), find=quote(c), replace=quote(formulops_expand(d, e)))
}
