% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npv_irr.R
\name{npv_irr}
\alias{npv_irr}
\title{Calculate Net Present Value and other economic variables}
\usage{
npv_irr(
  df,
  year,
  cost,
  revenue,
  rate,
  output = "full",
  sens_limits = c(1, 30),
  big_mark = ",",
  dec_mark = ".",
  prefix = "$"
)
}
\arguments{
\item{df}{A data frame.}

\item{year}{Quoted name of the year variable.}

\item{cost}{Quoted name of the costs variable.}

\item{revenue}{Quoted name of the revenue variable.}

\item{rate}{Numeric value of the yearly rate to be used.}

\item{output}{Selects different output options. It can be either \code{"full"} for a list containing a sensibility plot and a data frame with a single observation and one column for each variable, or \code{"simple"} for a two column data frame with one observation for each calculated variable. Default: \code{"simple"}.}

\item{sens_limits}{Selects the rate rage used in the sensibility plot. This is a numeric vector with two elements, the initial and final rate to be used as range. These can vary between 0 and 100. Default: \code{c(1,30)}.}

\item{big_mark}{Selects thousands separator. Can be either \code{"."}, \code{" "} or \code{","}. Default: \code{","}.}

\item{dec_mark}{Selects decimal separator. Can be either \code{","} or \code{"."}. Default: \code{"."}.}

\item{prefix}{selects the prefix for the y axis in the sensibility plot. Can be either \code{"$"} or \code{"R$"}. Default: \code{"$"}.}
}
\value{
A data frame, or a list, according to output.
}
\description{
Get the net present value, internal rate of return, and other 
economic variables, given cost and revenue values.
}
\examples{
\dontrun{
library(forestmangr)
data(exfm22)

npv_irr(exfm22,"year","cost","revenue",rate=8.75)

# To also get a sensibility plot, use

npv_irr(exfm22,"year","cost","revenue",rate=8.75, output="full")
} 
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
