#' @title 
#' Inventory data of an eucalyptus forest in minas gerais, Brazil
#' @description 
#' In this data, each observation is a tree.
#' @usage 
#' data(exfm9)
#' 
#' @format
#' A data frame with 900 observations and 14 variables:
#' \describe{
#'   \item{MAP}{map numbers}
#'   \item{PROJECT}{project number}
#'   \item{STRATA}{stratum number}
#'   \item{GENCODE}{genetic code of plots}
#'   \item{STRATA_AREA}{area of each strata, in hectares}
#'   \item{PLANTING_DATE}{date of planting}
#'   \item{SPACING}{Spacing used in the plots, in meters}
#'   \item{PLOT}{plot number}
#'   \item{MEASUREMENT_DATE}{date of measurement}
#'   \item{PLOT_AREA}{area of plots, in square meters}
#'   \item{PIT}{pit number}
#'   \item{DBH}{diameter at breast height, in centimeters}
#'   \item{TH}{total height, in meters}
#'   \item{OBS}{quality of trees, N = normal tree, D = dominant tree, F = a failure, or dead tree}
#' }
#' @name exfm9
#' @docType data
#' @author Sollano Rabelo Braga \email{sollanorb@@gmail.com}
#' @keywords data
NULL