% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_df.R
\name{round_df}
\alias{round_df}
\title{Round all numeric variables of a data frame to a given digit}
\usage{
round_df(df, digits, rf = "round")
}
\arguments{
\item{df}{A data frame.}

\item{digits}{Numeric vector for the desired number of digits.}

\item{rf}{Type of round to be used. It can either be \code{"ceiling"}, \code{"floor"}, \code{"trunc"}, \code{"signif"}, or \code{"round"}. Default \code{"round"}.}
}
\value{
A data frame, with all the numeric variables rounded up to the number given to \code{digits}.
}
\description{
This function allows the user to round all numeric values of a data frame,
directly, even if the data frame contains non-numeric variables
(which would throw an error in the \link[base]{round} function).
}
\examples{
library(forestmangr)

# Round all numeric variables
round_df(iris) 

# Round all numeric variables using the floor function
round_df(iris, rf="floor") 

# Do not run
# trying this with the the base function throws an error:

# round(iris)

}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
