% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/land-cover.R
\name{fd_landcover_copernicus}
\alias{fd_landcover_copernicus}
\title{Global Land Cover}
\usage{
fd_landcover_copernicus(
  x,
  lon = NULL,
  lat = NULL,
  year = 2019,
  layer = "forest",
  crop = FALSE,
  ...
)
}
\arguments{
\item{x}{an \code{sf} or \code{SpatVector} object. It will retrieve the
necessary tiles to cover the area (if \code{lat} and \code{lon} are
specified, this argument is ignored)}

\item{lon}{a number specifying the longitude of the area where we want the tile}

\item{lat}{a number specifying the latitude of the area where we want the tile}

\item{year}{year of the land cover data. One of 2015:2019 or 'all'}

\item{layer}{a character vector of the layer(s) to use from the Global
Land Cover. See details}

\item{crop}{when \code{x} is specified, whether to crop the tile(s) to the object}

\item{...}{additional arguments passed to the \link[terra]{crop} function}
}
\value{
\code{SpatRaster} object
}
\description{
Download a \code{SpatRaster} from the Global Land Cover from the Copernicus Global
Land Service.
}
\details{
There are 14 different layers that can be downloaded:
\itemize{
\item \strong{"discrete"}: land cover discrete classification
\item \strong{"classification"}: land cover classification probability
\item \strong{"bare"}: cover fraction of bare and sparse vegetation
\item \strong{"builtup"}: cover fraction of builtup
\item \strong{"crops"}: cover fraction of cropland
\item \strong{"tree"}: cover fraction of forest
\item \strong{"grass"}: cover fraction of herbaceous vegetation
\item \strong{"mosslichen"}: cover fraction of moss and lichen
\item \strong{"seasonalwater"}: cover fraction of seasonal inland water
\item \strong{"shrub"}: cover fraction of shrubland
\item \strong{"snow"}: cover fraction of snow and ice
\item \strong{"permanentwater"}: cover fraction of permanent inland water
\item \strong{"forest"} (default): forest types. (0): unknown; (1): evergreen needle leaf forest;
(2): evergreen broad leaf forest; (3): deciduous needle leaf; (4): deciduous
broad leaf; (5): mix of forest types
\item \strong{"datadensityindicator"}: input data density
}
}
\examples{
\donttest{
 # Get tile for Galicia (Spain) and year 2019
 galicia_forest_extent <- fd_landcover_copernicus(
  lat  = 42.7,
  lon  = -7.8,
  year = 2019
 )
 # Get forest and discrete classification tiles for all years
 galicia_forest_extent <- fd_landcover_copernicus(
  lat  = 42.7,
  lon  = -7.8,
  year = "all",
  layer = c("forest", "discrete")
 )
 }
}
\references{
Buchhorn, M.; Smets, B.; Bertels, L.; De Roo, B.; Lesiv, M.;
Tsendbazar, N. - E.; Herold, M.; Fritz, S. Copernicus Global
Land Service: Land Cover 100m: collection 3: epoch 2019: Globe
2020. DOI 10.5281/zenodo.3939050
}
