% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.ets}
\alias{simulate.ets}
\alias{simulate.Arima}
\alias{simulate.ar}
\alias{simulate.fracdiff}
\alias{simulate.nnetar}
\title{Simulation from a time series model}
\usage{
\method{simulate}{ets}(object, nsim = length(object$x), seed = NULL,
  future = TRUE, bootstrap = FALSE, innov = NULL, ...)

\method{simulate}{Arima}(object, nsim = length(object$x), seed = NULL,
  xreg = NULL, future = TRUE, bootstrap = FALSE, innov = NULL,
  lambda = object$lambda, ...)

\method{simulate}{ar}(object, nsim = object$n.used, seed = NULL,
  future = TRUE, bootstrap = FALSE, innov = NULL, ...)

\method{simulate}{fracdiff}(object, nsim = object$n, seed = NULL,
  future = TRUE, bootstrap = FALSE, innov = NULL, ...)

\method{simulate}{nnetar}(object, nsim = length(object$x), seed = NULL,
  xreg = NULL, future = TRUE, bootstrap = FALSE, innov = NULL,
  lambda = object$lambda, ...)
}
\arguments{
\item{object}{An object of class "\code{ets}", "\code{Arima}", "\code{ar}"
or "\code{nnetar}".}

\item{nsim}{Number of periods for the simulated series. Ignored if either
\code{xreg} or \code{innov} are not \code{NULL}.}

\item{seed}{Either \code{NULL} or an integer that will be used in a call to
\code{\link[base]{set.seed}} before simulating the time series. The default,
\code{NULL}, will not change the random generator state.}

\item{future}{Produce sample paths that are future to and conditional on the
data in \code{object}. Otherwise simulate unconditionally.}

\item{bootstrap}{Do simulation using resampled errors rather than normally
distributed errors or errors provided as \code{innov}.}

\item{innov}{A vector of innovations to use as the error series. Ignored if
\code{bootstrap==TRUE}. If not \code{NULL}, the value of \code{nsim} is set
to length of \code{innov}.}

\item{...}{Other arguments, not currently used.}

\item{xreg}{New values of \code{xreg} to be used for forecasting. The value
of \code{nsim} is set to the number of rows of \code{xreg} if it is not
\code{NULL}.}

\item{lambda}{Box-Cox parameter. If not \code{NULL}, the simulated series is
transformed using an inverse Box-Cox transformation with parameter
\code{lamda}.}
}
\value{
An object of class "\code{ts}".
}
\description{
Returns a time series based on the model object \code{object}.
}
\details{
With \code{simulate.Arima()}, the \code{object} should be produced by
\code{\link{Arima}} or \code{\link{auto.arima}}, rather than
\code{\link[stats]{arima}}. By default, the error series is assumed normally
distributed and generated using \code{\link[stats]{rnorm}}. If \code{innov}
is present, it is used instead. If \code{bootstrap=TRUE} and
\code{innov=NULL}, the residuals are resampled instead.

When \code{future=TRUE}, the sample paths are conditional on the data. When
\code{future=FALSE} and the model is stationary, the sample paths do not
depend on the data at all. When \code{future=FALSE} and the model is
non-stationary, the location of the sample paths is arbitrary, so they all
start at the value of the first observation.
}
\examples{
fit <- ets(USAccDeaths)
plot(USAccDeaths, xlim=c(1973,1982))
lines(simulate(fit, 36), col="red")

}
\seealso{
\code{\link{ets}}, \code{\link{Arima}}, \code{\link{auto.arima}},
\code{\link{ar}}, \code{\link{arfima}}, \code{\link{nnetar}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
