% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_fp_data.R
\name{segment_fp_data}
\alias{segment_fp_data}
\title{Segmentation to Data per Trial}
\usage{
segment_fp_data(
  filenames,
  n.trials,
  start.trigger,
  start.prepend = 0,
  baseline.trigger,
  baseline.intv,
  stimulus.trigger.list,
  response.trigger.list,
  cond.trigger.list,
  variable.names = NULL,
  skip = 19,
  az0 = 0,
  sampling.freq = 1000,
  cutoff.freq = 10,
  imputation = NULL,
  sort = TRUE
)
}
\arguments{
\item{filenames}{A (vector of) character(s) providing the raw force-plate file name(s). Files should be in tab-delimited .txt-format.}

\item{n.trials}{A (vector of) number(s) providing the number of trial (per filename).}

\item{start.trigger}{A (vector of) number(s) providing the trigger(s) marking the beginning of a trial.}

\item{start.prepend}{A number giving the number of milliseconds to prepend before the \code{start.trigger}.
If this is not 0 then each trial will have additional \code{start.prepend} milliseconds added at the
beginning of each trial.}

\item{baseline.trigger}{A (vector of) number(s) providing the trigger number(s) providing the reference for
the intervall for the baseline correction. For example, if set to 1 the onset of event with trigger 1 is
used as zero point for the next argument (\code{baseline.intv}). Use 0 to indicate that you wish to use no
baseline correction.}

\item{baseline.intv}{A vector of length 2 providing the lower and upper bounds of the interval that will
be used as baseline interval (in milliseconds). For each measurement variable, the mean of the data points
that fall into this interval will be subtracted from all data points within a trial.}

\item{stimulus.trigger.list}{If a trial contains one task only, then a vector providing the trigger(s)
marking the onset of the stimulus. If a trial contains more than one task, then a named list of vectors
providing the trigger(s) marking the onset of stimuli. For example,
\code{visual = c(4, 5), auditory = c(16, 17)}.}

\item{response.trigger.list}{Same as \code{stimulus.trigger.list} but with trigger(s) marking the onset
of responses. For example, \code{auditory = c(32, 33, 34, 36), visual = c(128, 129, 130, 132)}.}

\item{cond.trigger.list}{A named list of vectors providing the trigger(s) marking the conditions.}

\item{variable.names}{If used (i.e., not NULL), a named list of names. This will rename the variables of the
force-plate data. There are three cases to consider:
\itemize{
\item the time variable: if your force-plate data does not contain a variable with the string "time" in it
or you want to rename the time variable in the force-plate data, you can specify
\code{time = "fp_time_name"} in the \code{variable.names} list. The left hand side must be an expression
that contains the string "time". The right hand side must be the actual variable name in your raw force-plate data
you want to replace.
\item the parallel-port pin variable: if your force-plate data does not contain variables with the string "pin" in it
or you want to rename the pin variables in the force-plate data, you can specify
\code{pin1 = "fp_pin1_name"}, \code{pin2 = "fp_pin2_name"}, \code{pin3 = "fp_pin3_name"}, and so on, in the
\code{variable.names} list. The left hand side must be the string "pin" followed by a number. The right hand side
must be the actual variable name in the force-plate data you want to replace.
\item measurement variables: if you wish to rename some measurement variables in your force-plate data you can do so.
The only restriction being that the right hand side does not contain the strings "time" nor "pin". For example
\code{y_Force = "Fy"} is allowed. But we recommend sticking with the six basic measurement variable names
"Fx", "Fy", "Fz", "Mx", "My", and "Mz".
}}

\item{skip}{A number giving the number of lines in the raw force-plate data to skip. In BioWare this is 19. The real data
starts at line 20. Therefore the default value is set to 19.}

\item{az0}{Thickness parameter of the force plate in millimeter and negative. If this value (e.g., -41 for the Kistler
force plate type 9260AA) is not 0 then the center of pressure in the x- and y-direction is calculated (like in
Johannsen et al., 2023) using this value.}

\item{sampling.freq}{A number giving the sampling frequency. Typically 1000 Hz.}

\item{cutoff.freq}{A number giving the cut-off frequency used for the low-pass 4th order Butterworth filter. If set to 0,
no low-pass filter will be applied. Default is 10 Hz.}

\item{imputation}{If you expect any NaNs in your raw force-plate data you might use this argument. Use either of the
following options: "fmm", "periodic", "natural", "monoH.FC", or "hyman". These are method options in the
\code{stats::spline()} function. Usually this option is not needed and the default (NULL) can be used.}

\item{sort}{TRUE or FALSE. If TRUE the data will be sorted by subject number and block number.}
}
\value{
A \code{data.table} of the class \code{fp.segm}.
The following variables are included in the \code{data.table}:
\itemize{
\item \code{subj}: subject number,
\item \code{block}: block number,
\item \code{trial}: trial number,
\item \code{forceplate}: force-plate data of each trial as \code{data.table}. Use, for example,
\code{fp.dt$forceplate[[1]]} to open the force-plate data of the first trial, first block, and first subject.
}
}
\description{
Processing force-plate data by segmenting the data in trials, baseline correct each trial (optional),
applying a low-pass 4th order Butterworth filter (optional), labeling stimuli and response onsets
in each trial, labeling conditions in each trial, and some more (see below). The output is a
\code{data.table}.
}
\examples{
# Using example data from GitHub which requires internet
\donttest{ # takes longer than 5 seconds
if (curl::has_internet()) {
  url <- paste0("https://raw.githubusercontent.com/RaphaelHartmann/forceplate/",
                "main/data/subj013_block001.txt")
  
  # Safe download, handling potential errors
  tryCatch({
    filenames <- tempfile(pattern = c("subj013_block001_"), 
                          tmpdir = tempdir(), fileext = ".txt")
    download.file(url, filenames)
    
    # segment raw text file from Bioware
    fp.dt <- segment_fp_data(filenames = filenames, n.trials = 80, baseline.trigger = 128,
                             baseline.intv = c(0, 215), start.trigger = 128, start.prepend = 0,
                             stimulus.trigger.list = c(1, 2, 4, 8),
                             response.trigger.list = c(32, 64),
                             cond.trigger.list = list(stimulus = c(1, 2, 4, 8), 
                                                      correctness = c(32, 64)))
    
    # Clean up
    unlink(filenames)
  }, error = function(e) {
    message("Failed to download data: ", e$message)
  })
}
}

}
\references{
Johannsen, L., Stephan, D. N., Straub, E., Döhring, F., Kiesel, A., Koch, I., & Müller, H. (2023). Assessing the influence of cognitive response conflict on balance control: An
event-related approach using response-aligned force-plate time series data.
\emph{Psychological Research, 87}, 2297–2315.

Winter, D. A. (2009). \emph{Biomechanics and Motor Control of Human Movement}.
}
\author{
Raphael Hartmann & Anton Koger
}
