% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cropping.R
\name{crop_measurement}
\alias{crop_measurement}
\title{Crop Time Series}
\usage{
crop_measurement(file, path.data = NULL)
}
\arguments{
\item{file}{File path to measurement.}

\item{path.data}{A string character defining where to save the results. If \code{NULL},
data is not stored in a file. Default: \code{NULL}.}
}
\value{
Returns and, if \verb{path.data is not NULL}, saves data in
csv-format in \code{path.data}. \cr
\cr
The tibble has the following format:\tabular{ccc}{
   \strong{\code{t}} \tab  \tab \strong{\code{y}} \cr
   \code{t.1} \tab  \tab \code{y.1} \cr
   \code{...} \tab  \tab \code{...} \cr
   \code{t.n} \tab  \tab \code{y.n} \cr
}
}
\description{
Interactive function to crop a time series.
}
\details{
Select points at start and end of desired part of measurements.
Only the last two points will be
taken into account to allow the user to correct erroneous clicks.
}
\examples{
# get file path of forceR example file
filename <- forceR_example(type = "raw")

# # crop file without storing result as file - out-commented to pass package tests
# file.cropped <- crop_measurement(file = filename,
#                    path.data = NULL)

# file.cropped

}
