% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foot_rank.R
\name{foot_rank}
\alias{foot_rank}
\title{Rank and points predictions}
\usage{
foot_rank(data, object, team_sel, visualize = c("aggregated", "individual"))
}
\arguments{
\item{data}{A data frame, or a matrix containing the following mandatory items: home team, away team,
home goals, away goals.}

\item{object}{An object of class \code{\link[rstan]{stanfit}} as given by \code{stan_foot} function.}

\item{team_sel}{Selected team(s). By default, all the teams are selected.}

\item{visualize}{Type of plot, default is \code{"aggregated"}.}
}
\value{
Final rank tables and plots with the predicted points for the selected teams as given by the models fitted via the \code{stan_foot}
function.
}
\description{
Posterior predictive plots and final rank table for football seasons.
}
\details{
For Bayesian models fitted via \code{stan_foot} the final rank tables are computed according to the
simulation from the posterior predictive distribution of future (out-of-sample) matches.
The dataset should refer to one or more seasons from a given national football league (Premier League, Serie A, La Liga, etc.).
}
\examples{

\donttest{
if(requireNamespace("engsoccerdata")){
require(engsoccerdata)
require(tidyverse)

italy_1999_2000<- italy \%>\%
dplyr::select(Season, home, visitor, hgoal,vgoal) \%>\%
dplyr::filter(Season == "1999"|Season=="2000")

fit <- stan_foot(italy_2000, "double_pois", iter = 200)
foot_rank(italy_1999_2000, fit)
foot_rank(italy_1999_2000, fit, visualize =  "individual")
 }
}


}
\author{
Leonardo Egidi \email{legidi@units.it}
}
