% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_folders.R
\name{get_folders}
\alias{get_folders}
\title{Get Folders}
\usage{
get_folders(
  conf_file = NULL,
  conf_name = Sys.getenv("R_CONFIG_NAME"),
  save_conf = TRUE
)
}
\arguments{
\item{conf_file}{(character) Configuration file to read/write.
See: config::get().}

\item{conf_name}{(character) Name of configuration to read.
See: config::get(). (Default: Sys.getenv("R_CONFIG_NAME"))}

\item{save_conf}{(boolean) Whether or not to save new configuration file.
(Default: TRUE)}
}
\value{
(list) The named folders for a standard file structure, will be
    returned as a list.
}
\description{
Return a named list of standard folder names. Save a config file if missing.
}
\section{Details}{

The list of folders can be used to create any which are missing or to
refer to a folder path by name to avoid hardcoding paths in scripts.
You can refer to folders in this way to avoid the use of setwd() in scripts.

Ideally the folder paths will be subfolders relative to the parent folder
and will be standard names used in several projects for consistency.

If there is a configuration file, then it will be read with config::get().
Otherwise a built-in default list will be returned. If you want to use a
list from a non-default section of the configuration file, set the name of
the section with the "conf_name" parameter.
}

\examples{
conf_file <- tempfile("folders.yml")
folders <- get_folders(conf_file)
folders <- get_folders(conf_file, conf_name = "custom")
Sys.setenv(R_CONFIG_NAME = "custom")
folders <- get_folders(conf_file)
}
\keyword{consistency}
