% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcat.R
\name{as.data.frame.fcat}
\alias{as.data.frame.fcat}
\title{Convert a format catalog to a data frame}
\usage{
\method{as.data.frame}{fcat}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{The format catalog to convert.}

\item{row.names}{Row names of the return data frame.  Default is NULL.}

\item{optional}{TRUE or FALSE value indicating whether converting to
syntactic variable names is desired.  In the case of formats, the 
resulting data frame will always be returned with syntactic names, and 
this parameter is ignored.}

\item{...}{Any follow-on parameters.}
}
\value{
A data frame that contains the values stored in the format 
catalog.
}
\description{
This function takes the information stored in a format 
catalog, and converts it to a data frame.  This data frame is 
useful for storage, editing, saving to a spreadsheet, etc.  The 
data frame shows the name of the formats, their type, and the format 
expression.  For user-defined formats, the data frame populates 
additional columns for the label and order.
}
\examples{
# Create a format catalog
c1 <- fcat(num_fmt  = "\%.1f",
           label_fmt = value(condition(x == "A", "Label A"),
                             condition(x == "B", "Label B"),
                             condition(TRUE, "Other")),
           date_fmt = "\%d\%b\%Y")
           
# Convert catalog to data frame to view the structure
df <- as.data.frame(c1)
print(df)
#       Name Type Expression   Label Order
# 1   num_fmt    S       \%.1f            NA
# 2 label_fmt    U   x == "A" Label A    NA
# 3 label_fmt    U   x == "B" Label B    NA
# 4 label_fmt    U       TRUE   Other    NA
# 5  date_fmt    S     \%d\%b\%Y            NA

# Convert data frame back to a format catalog
c2 <- as.fcat(df)
c2
# # A format catalog: 3 formats
# - $date_fmt: type S, "\%d\%b\%Y"
# - $label_fmt: type U, 3 conditions
# - $num_fmt: type S, "\%.1f"
}
\seealso{
Other fcat: 
\code{\link{as.fcat}()},
\code{\link{as.fcat.data.frame}()},
\code{\link{as.fcat.fmt_lst}()},
\code{\link{as.fcat.list}()},
\code{\link{fcat}()},
\code{\link{is.fcat}()},
\code{\link{print.fcat}()},
\code{\link{read.fcat}()},
\code{\link{write.fcat}()}
}
\concept{fcat}
