% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing.R
\name{fmpc_price_history_spldiv}
\alias{fmpc_price_history_spldiv}
\title{Historical EOD pricing, split, and dividend data for one or more symbols}
\usage{
fmpc_price_history_spldiv(
  symbols = "AAPL",
  startDate = Sys.Date() - 360,
  endDate = Sys.Date()
)
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_by_market}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}

\item{startDate}{filter start date in yyyy-mm-dd format.}

\item{endDate}{filter end date in yyyy-mm-dd format.}
}
\value{
a data frame of pricing, split, and dividend history
}
\description{
Pulls End of Day prices, splits, and dividends for a list of symbols. Symbol
can include equity, mutual fund, index, currency, crypto, or any other symbol
that can be found in \code{\link{fmpc_symbols_by_market}}.
}
\details{
Uses functions \code{\link{fmpc_price_history}},
\code{\link{fmpc_security_dividends}}, and \code{\link{fmpc_security_splits}}
to aggregate split, dividend, and pricing data into a single data frame.
Warnings may be generated that split data or dividend data was not returned.
Results will still show in this function if price_history data is available.
}
\section{Warning}{
 Each symbol is THREE separate API calls. If the API token
has monthly limits, this should be considered before making a bulk request.
Large Symbol requests will also take time because of the buffer time
between API calls.
}

\examples{



\dontrun{
# Setting API key to 'demo' allows for AAPL only
fmpc_set_token()
fmpc_price_history_spldiv('AAPL')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
# Index, currency, and crypto will return data even without splits/divs
fmpc_price_history_spldiv(c('AAPL','MSFT','SPY','^SP500TR','JPYUSD','BTCUSD'))

}
}
