% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bary.R
\name{fm_bary}
\alias{fm_bary}
\alias{fm_bary.fm_mesh_1d}
\alias{fm_bary.fm_mesh_2d}
\alias{fm_bary.inla.mesh}
\alias{fm_bary.inla.mesh.1d}
\title{Compute barycentric coordinates}
\usage{
fm_bary(mesh, loc, ...)

\method{fm_bary}{fm_mesh_1d}(mesh, loc, method = c("linear", "nearest"), restricted = FALSE, ...)

\method{fm_bary}{fm_mesh_2d}(mesh, loc, crs = NULL, ...)

\method{fm_bary}{inla.mesh}(mesh, ...)

\method{fm_bary}{inla.mesh.1d}(mesh, ...)
}
\arguments{
\item{mesh}{\code{fm_mesh_1d} or \code{fm_mesh_2d} object}

\item{loc}{Points for which to identify the containing triangle, and
corresponding barycentric coordinates. May be a vector (for 1d) or
raw matrix coordinates, \code{sf}, or \code{sp} point information (for 2d).}

\item{\dots}{Arguments forwarded to sub-methods.}

\item{method}{character; method for defining the barycentric coordinates,
"linear" (default) or "nearest"}

\item{restricted}{logical, used for \code{method="linear"}.
If \code{FALSE} (default), points outside the mesh interval will be given
barycentric weights less than 0 and greater than 1, according to linear
extrapolation. If \code{TRUE}, the barycentric weights are clamped to the (0, 1)
interval.}

\item{crs}{Optional crs information for \code{loc}}
}
\value{
A list with elements \code{t} (vector of triangle indices or matrix of
interval knot indices), and \code{bary}, a matrix of barycentric coordinates.
}
\description{
Identify knot intervals or triangles and compute barycentric coordinates
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_bary(fm_mesh_1d)}: Return a list with elements
\code{t} (start and endpoint knot indices) and \code{bary} (barycentric coordinates), both
2-column matrices.

For \code{method = "nearest"}, \code{t[,1]} contains the index of the nearest mesh knot,
and each row of \code{bary} contains \code{c(1, 0)}.

\item \code{fm_bary(fm_mesh_2d)}: A list with elements \code{t} (vector of triangle indices) and \code{bary}
(3-column matrix of barycentric coordinates). Points that were not found
give \code{NA} entries in \code{t} and \code{bary}.

}}
\examples{
str(fm_bary(fmexample$mesh, fmexample$loc_sf))
str(fm_bary(fm_mesh_1d(1:4), seq(0, 5, by = 0.5)))
}
