% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currency-class.R
\name{Currency}
\alias{Currency}
\title{Build a Currency}
\usage{
Currency(iso, calendar)
}
\arguments{
\item{iso}{a three letter code representing the currency (see \href{https://en.wikipedia.org/wiki/ISO_4217}{ISO4217})}

\item{calendar}{a \link[fmdates:JointCalendar]{JointCalendar}}
}
\value{
an object of class \code{Currency}
}
\description{
A currency refers to money in any form when in actual use or circulation, as
a medium of exchange, especially circulating paper money. This package
includes handy constructors for common currencies.
}
\examples{
library("fmdates")
Currency("AUD", c(AUSYCalendar()))
}
\references{
\href{http://en.wikipedia.org/w/index.php?title=Currency&oldid=598027200}{Currency. (2014, March 3). In Wikipedia}
}
\seealso{
\link{CurrencyConstructors}
}
