% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_discrepancies.R
\name{solve_discrepancies}
\alias{solve_discrepancies}
\title{Resolve discrepancies between species and subspecies/varieties information}
\usage{
solve_discrepancies(data)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_florabr}} function.}
}
\value{
a data.frame with the discrepancies solved
}
\description{
Resolve discrepancies between species and subspecies/varieties information
}
\details{
In the original dataset, discrepancies may exist between species and
subspecies/varieties information. An example of a discrepancy is when a
species occurs only in one biome (e.g., Amazon), but a subspecies or variety
of the same species occurs in another biome (e.g., Cerrado). This function
rectifies such discrepancies by considering distribution (states, biomes,
and vegetation), life form, and habitat. For instance, if a subspecies is
recorded in a specific biome, it implies that the species also occurs in that
biome.
}
\examples{
data("bf_data") #Load Flora e Funga do Brasil data
#Check if discrepancies were solved in the dataset
attr(bf_data, "solve_discrepancies")
#Solve discrepancies
bf_solved <- solve_discrepancies(bf_data)
#Check if discrepancies were solved in the dataset
attr(bf_solved, "solve_discrepancies")
}
