% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen.r
\name{eigen}
\alias{eigen}
\alias{eigen,float32-method}
\title{eigen}
\usage{
\S4method{eigen}{float32}(x, symmetric, only.values = FALSE, EISPACK = FALSE)
}
\arguments{
\item{x}{A float vector/matrix.}

\item{symmetric}{Is the matrix symmetric? If not, it will be tested for symmetry with
\code{isSymmetric()}. Note that only symmetric matrices are supported at this
time.}

\item{only.values}{Should only the values (and not the vectors) be returned?}

\item{EISPACK}{Ignored.}
}
\value{
A list containing the values and optionally vectors, each stored as floats.
}
\description{
Solve a system of equations or invert a float matrix.
}
\examples{
library(float)

s = flrunif(10, 3)
cp = crossprod(s)

eigen(cp)

}
