\name{flip.object-class}
\Rdversion{1.1}
\docType{class}
\alias{draw}
\alias{p.value}
\alias{plot}
\alias{size}
\alias{result}
\alias{getFlip}
\alias{cFlip}
\alias{flip.object-class}
\alias{[,flip.object-method}
\alias{[[,flip.object-method}
\alias{hist,flip.object-method}
\alias{length,flip.object-method}
\alias{names,flip.object-method}
\alias{names<-,flip.object-method}
\alias{p.value,flip.object-method}
\alias{plot,flip.object-method}
\alias{result,flip.object-method}
\alias{show,flip.object-method}
\alias{size,flip.object-method}
\alias{sort,flip.object-method}
\alias{summary,flip.object-method}
\alias{p.adjust,flip.object-method}
\alias{numericOrmatrixOrNULL-class}
\alias{arrayOrNULL-class}
\alias{data.frameOrNULL-class}
\alias{numericOrmatrixOrNULL}
\alias{arrayOrNULL}
\alias{data.frameOrNULL}
\title{Class "flip.object" (and related functions) for storing the result of the function flip and flipMix}
\description{	
The class flip.object is the output of a call to
\code{\link{flip}}, \code{\link{flipMix}}, \code{\link{npc}} and \code{\link{flip.adjust}}. 
It stores the information needed for various diagnostic plots. 
Specific functions to deal with these objects are also documented here.}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("flip.object", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{res}:}{Object of class \code{flip.object} }
    \item{\code{call}:}{Object of class \code{"call"} }
    \item{\code{permP}:}{A matrix p-values of size B x p (number of permutations x number of variables), first line representing the p-value computed on observed data.}
    \item{\code{permT}:}{A matrix test statistics of size B x p (number of permutations x number of variables), first line representing the test statistic computed on observed data.}
    \item{\code{permSpace}:}{ A list that may contain \code{B,n,rotFunct,permID}. \code{B} is the number of permutations/rotations, \code{n} number of observations (possibly after orthogonalization of the residuals), \code{rotFunct} is the function used to resample the elements. \code{permID} is a matrix permutation of size B x n (number of permutations x sampel size), first line representing the p-value computed on observed data. This matrix is usually generated by \code{make.permSpace} or
\code{make.signSpace}}
    \item{\code{permY}:}{Not implemented yet}
    \item{\code{tail}:}{tail of the alternative. 1 means right tail, -1 left tail and 0 is bidirectional alternative}
  }
}
\section{Methods}{
  \describe{
    \item{[}{Select tests from the \code{flip.object}. Tests can be selected by position of name. It also allow for grep-like selection.}
    \item{[[}{Same as \code{[} }
    \item{hist}{Produces a histogram to visualize the permutation test statistics (same as \code{globaltest:gt.object}) }
    \item{length}{Number of tests }
    \item{names}{\code{signature(x = "flip.object")}: ... }
    \item{names<-}{\code{signature(x = "flip.object")}: ... }
    \item{p.value}{Extracts p-values from the object.}
	\item{p.adjust}{Performs multiple testing correction and produces multiplicity-corrected p-values. See \code{\link[flip:flip.adjust]{flip.adjust}} for details. }
    \item{plot}{\code{signature(x = "flip.object", y = "missing")}. It plots the permutation space and the observed test statistic. The plot is an histogram (see \code{hist.flip.object}) if there is only one test, while it is a biplot when there are more variables. In this case the arrows of the rotations are colored in red when the associated \code{p-value(res)<=.05}. }
    \item{result}{report table of results}
    \item{show}{report table of results}
    \item{size}{Returns the size of permT (i.e. number of permutations X number of tests)}
    \item{sort}{Sorts the tests to increasing p-values.}
    \item{summary}{ Provides the call, the number of permutations. Option \code{star.signif}: \code{=TRUE} (default) set stars depending on the last column of p-values; \code{=FALSE} inhibits stars, \code{="p-value"} or any other names indicates the column to which the stars refer.}
	 }
}

\usage{
getFlip(obj, element)

cFlip(...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
    \item{obj}{Any \code{flip-object}}
    \item{element}{Character string of either slot names of \code{obj} (i.e. \code{"res","call","permP","permT"},
\code{"permSpace","permY","tail","data","call.env"}), elements of slot \code{obj@data} (e.g.
\code{"Y","X","Z","Strata"}) or columns of 
\code{obj@res} (usually \code{"Test","Stat",}\code{
"tail","p-value"}).
Specific uses: 
\code{"Adjust:"} returns all columns of adjusted p-values in \code{obj@res}.
Any among \code{"nperms","perms","B"} return the number of permutation used.
}
    \item{...}{\code{flip-object}s to be concatenated.}
}

\author{livio finos}
\examples{
showClass("flip.object")

y=matrix(rnorm(50),10,5)
colnames(y)=c("X1","X2","Y1","Y2","Y3")
res=flip(y)

## Sort by p-values
sort(res)

## Selecting tests
res[1:2]
#same as
res["X"]
#different from (it selects tests having "1" or "2" in the name)
res[c("1","2")]

## Concatenates two flip-objects
cFlip(res[1:2],res[5])


#plotting results
plot(flip(y))

#Get any slot of the flip-object. eg the permutation space:
head(getFlip(res,"permT"))
#Get any element of the list obj@data. eg Y:
getFlip(res,"Y")
#Get any columns of the results table: obj@res. eg Statistic (choose among colnames(obj@res) ):
getFlip(res,"Stat")
}
\keyword{classes}
