% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{border_inner_h}
\alias{border_inner_h}
\title{set inner borders}
\usage{
border_inner_h(x, border = NULL, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{border}{border properties defined by a call to \code{\link[=fp_border]{fp_border()}}}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
The function is applying a border to inner content of one
or all parts of a flextable.
}
\examples{
library(officer)
std_border = fp_border(color="orange", width = 1)

dat <- iris[c(1:5, 51:55, 101:105),]
ft <- flextable(dat)
ft <- border_remove(x = ft)

# add inner horizontal borders
ft <- border_inner_h(ft, border = std_border )
ft
}
\seealso{
Other borders management: 
\code{\link{border_inner_v}()},
\code{\link{border_inner}()},
\code{\link{border_outer}()},
\code{\link{border_remove}()},
\code{\link{hline_bottom}()},
\code{\link{hline_top}()},
\code{\link{hline}()},
\code{\link{surround}()},
\code{\link{vline_left}()},
\code{\link{vline_right}()},
\code{\link{vline}()}
}
\concept{borders management}
