% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{htmltools_value}
\alias{htmltools_value}
\title{flextable as a div object}
\usage{
htmltools_value(
  x,
  ft.align = opts_current$get("ft.align"),
  class = "tabwid",
  bookdown = FALSE
)
}
\arguments{
\item{x}{a flextable object}

\item{ft.align}{flextable alignment, supported values are 'left', 'center' and 'right'.}

\item{class}{css classes (default to "tabwid"), if ft.align is set to 'left' or 'right',
class 'tabwid_left' or 'tabwid_right' will be added to class.}

\item{bookdown}{\code{TRUE} or \code{FALSE} (default) to support cross referencing with bookdown.}
}
\description{
get a \code{\link[=div]{div()}} from a flextable object.
This can be used in a shiny application.

Argument \code{ft.align} can be specified also as knitr chunk options.
}
\examples{
htmltools_value(flextable(iris[1:5,]))
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{docx_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
