% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{font}
\alias{font}
\title{Set font}
\usage{
font(x, i = NULL, j = NULL, fontname, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{fontname}{string value, the font name.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
change font of selected rows and columns of a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_font_1.png}{options: width=70\%}}

\if{html}{\figure{fig_font_2.png}{options: width=70\%}}
}

\examples{
require("gdtools")
fontname <- "Brush Script MT"

if( font_family_exists(fontname) ){
  ft_1 <- flextable(head(iris))
  ft_2 <- font(ft_1, fontname = fontname, part = "header")
  ft_2 <- font(ft_2, fontname = fontname, j = 5)
  ft_2
}
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{fontsize}()},
\code{\link{italic}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
