% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{decode}
\alias{decode}
\title{Decode a flexible polyline encoded string}
\usage{
decode(encoded)
}
\arguments{
\item{encoded}{character, encoded flexible polyline string.}
}
\value{
A matrix containing the coordinates of the decoded line.
}
\description{
This function calls \code{hf::polyline_decode} and
\code{hf::get_third_dimension} of the C++ implementation of the flexible
polyline encoding by HERE. Depending on the dimensions of the encoded line,
a two or three dimensional line is decoded.
}
\examples{
# 2d line
decode("BFoz5xJ67i1B1B7PzIhaxL7Y")

# 3d line
decode("BlBoz5xJ67i1BU1B7PUzIhaUxL7YU")
}
