% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_combining.R
\name{subset.modeler}
\alias{subset.modeler}
\title{Subset an object of class \code{modeler}}
\usage{
\method{subset}{modeler}(x, id = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{modeler}, typically the result of calling \code{modeler()}.}

\item{id}{Unique identifier to filter a \code{modeler} object by a specific group. Default is \code{NULL}.}

\item{...}{Additional parameters for future functionality.}
}
\value{
A \code{modeler} object.
}
\description{
Subset an object of class \code{modeler}
}
\examples{
library(flexFitR)
data(dt_potato)
mod <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_logistic",
    parameters = c(L = 100, k = 4, t0 = 40),
    subset = 1:2
  )
print(mod)
mod_new <- subset(mod, id = 2)
print(mod_new)
}
\author{
Johan Aparicio [aut]
}
