% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkhist.R
\name{plot.rkhist}
\alias{plot.rkhist}
\title{Method for function \code{plot} an S3 object of class \code{rkhist}}
\usage{
\method{plot}{rkhist}(x, mini = min(0, min(x)), what = "counts", ...)
}
\arguments{
\item{x}{an \code{rkhist} S3 object containing the rank histogram to
plot. See function \code{flatness::rkhist}.}

\item{mini}{a numeric. The minimum value in the \code{ylim} argument
used to plot. Relevant only when plotting counts, ignored otherwise.}

\item{what}{a character string taking its value in
\code{c("counts", "percents", "proportions")}. What must be plotted.}

\item{...}{other arguments passed to function \code{base::plot.default}.
Some arguments are already used in this function, and may not be changed.}
}
\value{
\code{NULL}, invisibly.
}
\description{
Plot a rank histogram stored in an object of S3 class \code{rkhist}, with an
horizontal dashed line indicating the expected count for a perfectly flat
rank histogram.
}
