% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_aflw-player_stats.R
\name{get_aflw_player_stats}
\alias{get_aflw_player_stats}
\title{Return get match stats for all current AFLW matches}
\usage{
get_aflw_player_stats(
  start = 2017,
  end = as.numeric(format(Sys.Date(), "\%Y"))
)
}
\arguments{
\item{start}{optional, character string or numeric for start year, in "YYYY" format}

\item{end}{optional, character string or numeric for end year, in "YYYY"format}
}
\value{
a data table containing player stats for each game between start and end years
}
\description{
\code{get_aflw_player_stats} returns a data frame containing match stats for each game within the specified date range
}
\details{
This function returns a data frame containing match stats for each game within the specified date range. Returns 1 row per player.

The date for this function is called from an API with data stored in a PostgreSQL database on AWS.
Updated at the conclusion of every game. A cached version to come.
}
\examples{
#
\dontrun{
# Gets all data
get_aflw_player_stats()
# Specify a date range
get_aflw_player_stats(start = 2018, end = 2019)
}
}
