% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitode.R
\name{logLik.sensitivity}
\alias{logLik.sensitivity}
\title{Calculate the derivative of the log-likelihood function}
\usage{
logLik.sensitivity(
  parms,
  model,
  data,
  solver.opts = list(method = "rk4"),
  solver = ode,
  return.NLL = TRUE,
  return.traj = FALSE
)
}
\arguments{
\item{parms}{named vector of parameter values}

\item{model}{odemodel object}

\item{data}{data}

\item{solver.opts}{options for the ode solver (see \code{\link{ode}})}

\item{solver}{ode solver}

\item{return.NLL}{(logical) return negative log-likelihood}

\item{return.traj}{(logical) return estimated trajectory}
}
\value{
a vector of nll and derivative of nll with respect to model parameters
(or a list containing (1) the estimated traejctory and (2) a vector of nll and its derivatives)
}
\description{
Calculate the derivative of the log-likelihood function with respect to model parameters
using sensitivity equations and chain rule
}
\keyword{internal}
