#' Standard Industrial Classification Code List
#' 
#' A dataset containing SIC codes and industries that they represent
#'
#' @format A data frame with 444 rows and 2 variables:
#' \itemize{
#'   \item SIC: Standard Industrial Classification Code
#'   \item industry: Industry Title
#' }
#'  
#' @source \url{https://www.sec.gov/info/edgar/siccodes.htm}
"siccodes"

#' EDGAR State and Country Codes
#' 
#' A dataset containing state and country codes used in the SEC EDGAR database.
#' 
#' @format A data frame with 310 rows and 2 variables:
#'  \itemize{
#'   \item state: State or Country Code
#'   \item state.name: State or Country Name
#' }
#' 
#' @source \url{https://www.sec.gov/edgar/searchedgar/edgarstatecodes.htm}
"statecodes"