% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finbif_records.R
\name{finbif_records}
\alias{finbif_records}
\alias{fb_records}
\title{Get FinBIF records}
\usage{
finbif_records(
  filter = NULL,
  select = NULL,
  order_by = NULL,
  aggregate = "none",
  sample = FALSE,
  n = 10,
  page = 1,
  count_only = FALSE,
  quiet = getOption("finbif_hide_progress"),
  cache = getOption("finbif_use_cache"),
  dwc = FALSE,
  seed = NULL,
  df = FALSE,
  exclude_na = FALSE,
  locale = getOption("finbif_locale"),
  include_facts = FALSE
)
}
\arguments{
\item{filter}{List of named character vectors. Filters to apply to records.}

\item{select}{Character vector. Variables to return. If not specified, a
default set of commonly used variables will be used. Use \code{"default_vars"}
as a shortcut for this set. Variables can be deselected by prepending a \code{-}
to the variable name. If only deselects are specified the default set of
variables without the deselection will be returned.}

\item{order_by}{Character vector. Variables to order records by before they
are returned. Most, though not all, variables can be used to order records
before they are returned. Ordering is ascending by default. To return in
descending order append a \code{-} to the front of the variable (e.g.,
\code{"-date_start"}). Default order is \code{"-date_start"} > \code{"-load_data"} >
\code{"reported_name"}.}

\item{aggregate}{Character. If \code{"none"} (default), returns full records. If
one or more of \code{"records"}, \code{"species"}, \code{"taxa"}, \code{"individuals"},
\code{"pairs"}, \code{"events"} or \code{"documents"}; aggregates combinations of the
selected variables by counting records, species, taxa, individuals or
events or documents. Aggregation by events or documents cannot be done in
combination with any of the other aggregation types.}

\item{sample}{Logical. If \code{TRUE} randomly sample the records from the FinBIF
database.}

\item{n}{Integer. How many records to download/import.}

\item{page}{Integer. Which page of records to start downloading from.}

\item{count_only}{Logical. Only return the number of records available.}

\item{quiet}{Logical. Suppress the progress indicator for multipage
downloads. Defaults to value of option \code{finbif_hide_progress}.}

\item{cache}{Logical. Use cached data.}

\item{dwc}{Logical. Use Darwin Core (or Darwin Core style) variable names.}

\item{seed}{Integer. Set a seed for randomly sampling records.}

\item{df}{Logical. Should the data.frame representation of the records be
returned as an attribute?}

\item{exclude_na}{Logical. Should records where all selected variables have
non-NA values only be returned.}

\item{locale}{Character. One of the supported two-letter ISO 639-1 language
codes. Current supported languages are English, Finnish and Swedish. For
data where more than one language is available the language denoted by
\code{locale} will be preferred while falling back to the other languages in the
order indicated above.}

\item{include_facts}{Logical. Should all "fact" variables be included?}
}
\value{
A \code{finbif_api} or \code{finbif_api_list} object.
}
\description{
Download records from FinBIF. The function \code{finbif_records()} and its
associated classes and methods have been deprecated and user access will be
removed in the next release of the finbif package.
}
\examples{
\dontrun{

# Get the last 100 records from FinBIF
finbif_records(n = 100)

}
}
