% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_HardImpute.R
\name{fill.HardImpute}
\alias{fill.HardImpute}
\title{HardImpute : Generalized Spectral Regularization}
\usage{
fill.HardImpute(
  A,
  lambdas = c(10, 1, 0.1),
  maxiter = 100,
  tol = 0.001,
  rk = (min(dim(A)) - 1)
)
}
\arguments{
\item{A}{an \eqn{(n\times p)} partially observed matrix.}

\item{lambdas}{a length-\eqn{t} vector regularization parameters.}

\item{maxiter}{maximum number of iterations to be performed.}

\item{tol}{stopping criterion for an incremental progress.}

\item{rk}{assumed rank of the matrix.}
}
\value{
a named list containing \describe{
\item{X}{an \eqn{(n\times p\times t)} cubic array after completion at each \code{lambda} value.}
}
}
\description{
If the assumed underlying model has sufficiently many zeros, the LASSO type
shrinkage estimator is known to overestimate the number of non-zero coefficients.
\code{fill.HardImpute} aims at overcoming such difficulty via low-rank assumption
and hard thresholding idea, well-known concept in conventional regression analysis.
In algorithmic aspect, it takes output of \code{SoftImpute} as warm-start matrices
for iterative estimation process.
}
\examples{
## load image data of 'lena128'
data(lena128)

## transform 5\% of entries into missing
A <- aux.rndmissing(lena128, x=0.05)

## apply the method with 3 rank conditions
fill1 <- fill.HardImpute(A, lambdas=c(500,100,50), rk=10)
fill2 <- fill.HardImpute(A, lambdas=c(500,100,50), rk=50)
fill3 <- fill.HardImpute(A, lambdas=c(500,100,50), rk=100)

## visualize only the last ones from each run
par(mfrow=c(2,2), pty="s")
image(A, col=gray((0:100)/100), axes=FALSE, main="5\% missing")
image(fill1$X[,,3], col=gray((0:100)/100), axes=FALSE, main="Rank 10")
image(fill2$X[,,3], col=gray((0:100)/100), axes=FALSE, main="Rank 50")
image(fill3$X[,,3], col=gray((0:100)/100), axes=FALSE, main="Rank 100")

}
\references{
\insertRef{mazumder_spectral_2010}{filling}
}
\seealso{
\code{\link{fill.SoftImpute}}
}
