% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-num-after.R
\name{nth_number_after_mth}
\alias{nth_number_after_mth}
\alias{nth_number_after_first}
\alias{nth_number_after_last}
\alias{first_number_after_mth}
\alias{last_number_after_mth}
\alias{first_number_after_first}
\alias{first_number_after_last}
\alias{last_number_after_first}
\alias{last_number_after_last}
\title{Find the \eqn{n}th number after the \eqn{m}th occurrence of a pattern.}
\usage{
nth_number_after_mth(string, pattern, n, m, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

nth_number_after_first(string, pattern, n, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

nth_number_after_last(string, pattern, n, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

first_number_after_mth(string, pattern, m, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

last_number_after_mth(string, pattern, m, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

first_number_after_first(string, pattern, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

first_number_after_last(string, pattern, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

last_number_after_first(string, pattern, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

last_number_after_last(string, pattern, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{A character vector. Pattern(s) specified like the pattern(s)
in the stringr package (e.g. look at \code{\link[stringr:str_locate]{stringr::str_locate()}}). If
this has length >1 its length must be the same as that of \code{string}.}

\item{n, m}{Natural numbers.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}
}
\value{
A numeric vector.
}
\description{
Given a string, a pattern and natural numbers \code{n} and \code{m}, find the \code{n}th
number after the \code{m}th occurrence of the pattern.
}
\examples{
string <- c("abc1abc2abc3abc4abc5abc6abc7abc8abc9",
            "abc1def2ghi3abc4def5ghi6abc7def8ghi9")
nth_number_after_mth(string, "abc", 1, 3)
nth_number_after_mth(string, "abc", 2, 3)
nth_number_after_first(string, "abc", 2)
nth_number_after_last(string, "abc", -1)
first_number_after_mth(string, "abc", 2)
last_number_after_mth(string, "abc", 1)
first_number_after_first(string, "abc")
first_number_after_last(string, "abc")
last_number_after_first(string, "abc")
last_number_after_last(string, "abc")
}
