% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_filearray.R
\name{FileArray-class}
\alias{FileArray-class}
\title{Definition of file array}
\description{
\code{S4} class definition of \code{FileArray}. Please 
use \code{\link{filearray_create}} and \code{\link{filearray_load}}
to create instances.
}
\section{Public Methods}{

\describe{
\item{\code{can_write()}}{Whether the array data can be altered}
\item{\code{create(filebase, dimension, type = "double", partition_size = 1)}}{Create a file array instance}
\item{\code{delete(force = FALSE)}}{Remove array from local file system and reset}
\item{\code{dimension()}}{Get dimension vector}
\item{\code{dimnames(v)}}{Set/get dimension names}
\item{\code{element_size()}}{Internal storage: bytes per element}
\item{\code{fill_partition(part, value)}}{Fill a partition with given scalar}
\item{\code{get_partition(part, reshape = NULL)}}{Get partition data, and reshape (if not null) to desired dimension}
\item{\code{initialize_partition()}}{Make sure a partition file exists; if not, create one and fill with \code{NA}s or 0 (\code{type='raw'})}
\item{\code{load(filebase, mode = c("readwrite", "readonly"))}}{Load file array from existing directory}
\item{\code{partition_path(part)}}{Get partition file path}
\item{\code{partition_size()}}{Get partition size; see \code{\link{filearray}}}
\item{\code{set_partition(part, value, ..., strict = TRUE)}}{Set partition value}
\item{\code{sexp_type()}}{Get data \code{SEXP} type; see R internal manuals}
\item{\code{show()}}{Print information}
\item{\code{type()}}{Get data type}
\item{\code{valid()}}{Check if the array is valid.}
}
}

\seealso{
\code{\link{filearray}}
}
