% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spCentroid.R
\name{spCentroid}
\alias{spCentroid}
\title{spCentroid}
\usage{
spCentroid(x)
}
\arguments{
\item{x}{An object of class \emph{SpatialPoints} or \emph{SpatialPolygons}.}
}
\value{
A \emph{spatialPointsDataFrame} object.
}
\description{
Aggregates a spatial object into regions.
}
\details{
{Returns the centroid of each element in \emph{x}.}
}
\examples{
{

require(raster)

# read raster data
r <- brick(system.file("extdata", "ndvi.tif", package="fieldRS"))

# read field data
data(fieldData)

# derive centroids
c <- spCentroid(fieldData)

# plot polygons and compare with centroids
plot(fieldData)
points(c, col="red")

}
}
\seealso{
\code{\link{ecDistance}}
}
