% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fidofit_methods.R
\name{orthus_tidy_samples}
\alias{orthus_tidy_samples}
\title{Convert orthus samples of Eta Lambda and Sigma to tidy format}
\usage{
orthus_tidy_samples(m, use_names = FALSE, as_factor = FALSE)
}
\arguments{
\item{m}{an object of class orthusfit}

\item{use_names}{should dimension indices be replaced by
dimension names if provided in data used to fit pibble model.}

\item{as_factor}{if use_names should names be returned as factor?}
}
\value{
tibble
}
\description{
Combines them all into a single tibble, see example for formatting and 
column headers. Primarily designed to be used by 
\code{\link{summary.orthusfit}}.
}
\examples{
sim <- orthus_sim()
fit <- orthus(sim$Y, sim$Z, sim$X)
fit_tidy <- orthus_tidy_samples(fit, use_names=TRUE)
head(fit_tidy)
}
