% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{uncollapsePibble}
\alias{uncollapsePibble}
\title{Uncollapse output from optimPibbleCollapsed to full pibble Model}
\usage{
uncollapsePibble(
  eta,
  X,
  Theta,
  Gamma,
  Xi,
  upsilon,
  seed,
  ret_mean = FALSE,
  ncores = -1L
)
}
\arguments{
\item{eta}{array of dimension (D-1) x N x iter (e.g., \code{Pars} output of
function optimPibbleCollapsed)}

\item{X}{matrix of covariates of dimension Q x N}

\item{Theta}{matrix of prior mean of dimension (D-1) x Q}

\item{Gamma}{covariance matrix of dimension Q x Q}

\item{Xi}{covariance matrix of dimension (D-1) x (D-1)}

\item{upsilon}{scalar (must be > D) degrees of freedom for InvWishart prior}

\item{seed}{seed to use for random number generation}

\item{ret_mean}{if true then uses posterior mean of Lambda and Sigma
corresponding to each sample of eta rather than sampling from
posterior of Lambda and Sigma (useful if Laplace approximation
is not used (or fails) in optimPibbleCollapsed)}

\item{ncores}{(default:-1) number of cores to use, if ncores==-1 then
uses default from OpenMP typically to use all available cores.}
}
\value{
List with components
\enumerate{
\item Lambda Array of dimension (D-1) x Q x iter (posterior samples)
\item Sigma Array of dimension (D-1) x (D-1) x iter (posterior samples)
\item The number of cores used
\item Timer
}
}
\description{
See details for model. Should likely be called following
\code{\link{optimPibbleCollapsed}}. Notation: \code{N} is number of samples,
\code{D} is number of multinomial categories, \code{Q} is number
of covariates, \code{iter} is the number of samples of \code{eta} (e.g.,
the parameter \code{n_samples} in the function \code{optimPibbleCollapsed})
}
\details{
Notation: Let Z_j denote the J-th row of a matrix Z.
While the collapsed model is given by:
\deqn{Y_j ~ Multinomial(Pi_j)}
\deqn{Pi_j = Phi^{-1}(Eta_j)}
\deqn{Eta ~ T_{D-1, N}(upsilon, Theta*X, K, A)}
Where A = I_N + X * Gamma * X', K = Xi is a (D-1)x(D-1) covariance
matrix, Gamma is a Q x Q covariance matrix, and Phi^{-1} is ALRInv_D
transform.

The uncollapsed model (Full pibble model) is given by:
\deqn{Y_j ~ Multinomial(Pi_j)}
\deqn{Pi_j = Phi^{-1}(Eta_j)}
\deqn{Eta ~ MN_{D-1 x N}(Lambda*X, Sigma, I_N)}
\deqn{Lambda ~ MN_{D-1 x Q}(Theta, Sigma, Gamma)}
\deqn{Sigma ~ InvWish(upsilon, Xi)}
This function provides a means of sampling from the posterior distribution of
\code{Lambda} and \code{Sigma} given posterior samples of \code{Eta} from
the collapsed model.
}
\examples{
sim <- pibble_sim()

# Fit model for eta
fit <- optimPibbleCollapsed(sim$Y, sim$upsilon, sim$Theta\%*\%sim$X, sim$KInv, 
                             sim$AInv, random_pibble_init(sim$Y))  

# Finally obtain samples from Lambda and Sigma
fit2 <- uncollapsePibble(fit$Samples, sim$X, sim$Theta, 
                                   sim$Gamma, sim$Xi, sim$upsilon, 
                                   seed=2849)
}
\references{
JD Silverman K Roche, ZC Holmes, LA David, S Mukherjee.
Bayesian Multinomial Logistic Normal Models through Marginally Latent Matrix-T Processes.
2019, arXiv e-prints, arXiv:1903.11695
}
\seealso{
\code{\link{optimPibbleCollapsed}}
}
