% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fido_utils.R
\name{random_pibble_init}
\alias{random_pibble_init}
\title{Provide random initialization for pibble model}
\usage{
random_pibble_init(Y)
}
\arguments{
\item{Y}{matrix (D x N) of counts}
}
\value{
(D-1) x N matrix
}
\description{
Randomly initializes based on ALR transform of counts
plus random pseudocounts uniformily distributed between 
0 and 1.
}
\details{
Notation: \code{N} is number of samples and
\code{D} is number of multinomial categories
}
\examples{
Y <- matrix(sample(1:100, 100), 10, 10)
random_pibble_init(Y)
}
