% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{ffl_api}
\alias{ffl_api}
\title{Call the ESPN Fantasy API}
\usage{
ffl_api(
  leagueId = ffl_id(),
  view = NULL,
  leagueHistory = FALSE,
  seasonId = 2021,
  scoringPeriodId = NULL,
  ...
)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{view}{Character vector of specific API "views" which describe the data
returned (e.g., "mRoster", "mSettings").}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{seasonId}{Integer year of NFL season. By default, the season is
currently set to 2021. Use a recent year or set \code{leagueHistory} to \code{TRUE}
to obtain all past data.}

\item{scoringPeriodId}{Integer week of NFL season. By default, \code{NULL} will
use the current week (see \code{\link[=ffl_week]{ffl_week()}}). Scoring periods are always one
week in length, whereas matchups might be longer.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}. Arguments are
converted to a named list and passed to \code{query} alongside \code{view}.}
}
\value{
A single JSON string.
}
\description{
Use \code{\link[httr:GET]{httr::GET()}} to make a request to the ESPN API and return the parsed
list from the JSON data. The function uses \code{\link[httr:RETRY]{httr::RETRY()}}, so the call will
repeat up to three times if there is a failure.
}
\examples{
\dontrun{
ffl_api()
}
}
\keyword{internal}
