% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_overlap.R
\name{marginal_overlap}
\alias{marginal_overlap}
\title{Feasibility of all Marginal Ellipse Overlaps}
\usage{
marginal_overlap(ell, margins = "all")
}
\arguments{
\item{ell}{a list of at least two (non degenerate) ellipses; see
\code{\link{wrangle_ellipse}}.}

\item{margins}{either "all" or a vector indicating the margins to project the
ellipses onto and take intersections.}
}
\value{
\code{marginal_overlap} returns an object of \code{\link[base]{class}}
"marginal_overlap" which contains a data.frame where the coloumns descibe the
following
  \item{Margin}{Intputted \code{margins}.}
    \item{Overlap}{Whether the ellipses overlap when projected onto
      corresponding margin.}
    \item{Lower}{Lower endpoint of intersection interval. \code{NA} if the
      intersection is empty.}
    \item{Upper}{Upper endpoint of intersection interval. \code{NA} if the
      intersection is empty.}
}
\description{
Determin if the projections of ellipses onto each margin overlap.
}
\details{
The ellipses are projected onto the specified \code{margins}. For each margin
the intersection of the projected ellipses is found. The  \code{Lower} and
\code{Upper} endpoints of the intersection interval is reported. If the
intersection along a margin is empty then \code{Lower} and \code{Upper}
is reported as \code{NA}.

Note that if the ellipses overlap when projected onto each margin this does
not imply that the ellipses themselves intersect non-emptily. The example
below is constructed to illustrate this.
}
\examples{
## two dimensional ellipses
e1 <- list(c = c(0.1, 0), P = matrix(c(3, 0, 0, 1), ncol = 2), r = 1)
e2 <- list(c = c(1, 1), P = matrix(c(3, 1.2, 1.2, 1), ncol = 2), r = 0.8)
e3 <- list(c = c(2, 1.5), P = matrix(c(1, 0.6, 0.6, 1), ncol = 2), r = 0.4)
# Note: These three ellipses have been chosen so (some of) the marginal
#       projections intersect, but the actual ellipses do not intersect.

# Ellipses e1 and e2 overlap when projected onto margin 1 and 2 respectivly.
marginal_overlap(list(e1, e2))

# Adding ellipse e3:
# Then there is no overlap when projecting onto margin 1
marginal_overlap(list(e1, e2, e3), margins = c(1))


## regression example
n <- 100
E <- rbinom(n, 1, 0.5)
X <- rnorm(n, E * 3, 1)
Y <- rnorm(n, 2 + X, 1)
lm_E0 <- lm(Y ~ X, data = data.frame(Y, X), subset = (E == 0))
lm_E1 <- lm(Y ~ X, data = data.frame(Y, X), subset = (E == 1))

# create 95\% confidence ellipses and check marginal overlap
q <- qchisq(0.95, 2) # df = 2, as there are two covariates (1, X)
ell0 <- list(c = coefficients(lm_E0), S = vcov(lm_E0), r = q)
ell1 <- list(c = coefficients(lm_E1), S = vcov(lm_E1), r = q)
marginal_overlap(list(ell0, ell1))
}
\seealso{
\code{\link{wrangle_ellipse}} for detailed on ellipse
parameterization.
}
