% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{plotclus}
\alias{plotclus}
\title{Generic Plot Method for Clustering}
\usage{
plotclus(clustering, d = NULL, type = c("scatter", "boxplot", "tree",
  "height", "mapping"), centers = FALSE, k = NULL, tailsize = 9, ...)
}
\arguments{
\item{clustering}{The clustering to be plotted.}

\item{d}{The dataset (\code{matrix} or \code{data.frame}), mandatory for some of the graphics.}

\item{type}{The type of plot.}

\item{centers}{Indicates whether or not cluster centers should be plotted (used only in scatter plots).}

\item{k}{Number of clusters (used only for hierarchical methods). If not specified an "optimal" value is determined.}

\item{tailsize}{Number of clusters showned (used only for height plots).}

\item{...}{Other parameters.}
}
\description{
Plot a clustering according to various parameters
}
\examples{
require (datasets)
data (iris)
ward = HCA (iris [, -5], method = "ward", k = 3)
plotclus (ward, iris [, -5], type = "scatter") # Scatter plot
plotclus (ward, iris [, -5], type = "boxplot") # Boxplot
plotclus (ward, iris [, -5], type = "tree") # Dendrogram
plotclus (ward, iris [, -5], type = "height") # Distances between merging clusters
som = SOM (iris [, -5], xdim = 5, ydim = 5, post = "ward", k = 3)
plotclus (som, iris [, -5], type = "scatter") # Scatter plot for SOM
plotclus (som, iris [, -5], type = "mapping") # Kohonen map
}
\seealso{
\code{\link{treeplot}}, \code{\link{scatterplot}}, \code{\link{plot.som}}, \code{\link{boxclus}}
}
