% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussianPoFD.R
\name{gaussian_PoFD}
\alias{gaussian_PoFD}
\title{Gaussian Partially Observed Functional Data}
\usage{
gaussian_PoFD(n, p, type, observability, ninterval, pIncomplete = 1)
}
\arguments{
\item{n}{total number of functional observations}

\item{p}{total number of points observed for each function}

\item{type}{type of partially observed data. Options are "sparse", "interval" and "common". See Elías et al (2020).}

\item{observability}{mean observed proportion of the domain where each function is observed.}

\item{ninterval}{if type = "interval", n_interval is an integer with the number of observed intervals 1, 2, 3...
Large values of this parameter requires a large parameter p to guarantee the observability level.}

\item{pIncomplete}{number between 0 and 1 related to the proportion of curves that suffers partially observability.
The default is 1 meaning that all the sample curves are partially observed.}
}
\value{
a list containing two elements 1) a functional sample and 2) the same sample of functions but
partially observed following one of the schemes described in the argument type.
}
\description{
Generates samples of partially observed gaussian functions following different censoring regimes.
}
\examples{

gaussian_pofd <- gaussian_PoFD(n=100, p=200, type="sparse", observability=0.5)

}
\references{
Elías, Antonio, Jiménez, Raúl, Paganoni, Anna M. and Sangalli, Laura M. (2020). Integrated Depths for Partially Observed Functional Data.
}
