% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis_functions.R
\name{make.bspline.basis}
\alias{make.bspline.basis}
\title{Make b-spline basis}
\usage{
make.bspline.basis(knots, order = 4)
}
\arguments{
\item{knots}{Knots of the basis, including endpoints}

\item{order}{Spline order. Defaults to 4.}
}
\value{
Function of class "fctbasis"
}
\description{
Make B-spline basis
}
\examples{
## B-spline with equidistant knots with 13 basis function
bf <- make.bspline.basis(knots = 0:10, order = 4)

## B-spline of order 2 (ie. a linear approximation) with some uneven knots
bf <- make.bspline.basis(knots = c(-1.3, 0, 0.5, 0.7, 1.1), order = 2)


}
\seealso{
\link{Functional basis function}
}
