% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formal_context.R
\name{FormalContext}
\alias{FormalContext}
\title{R6 class for a formal context}
\description{
This class implements the data structure and methods for formal contexts.
}
\examples{
# Build and print the formal context
fc_planets <- FormalContext$new(planets)
print(fc_planets)

# Define a set of attributes
S <- Set$new(attributes = fc_planets$attributes)
S$assign(moon = 1, large = 1)

# Compute the closure of S
Sc <- fc_planets$closure(S)
# Is Sc a closed set?
fc_planets$is_closed(Sc)

# Clarify and reduce the formal context
fc2 <- fc_planets$reduce(TRUE)

# Find implications
fc_planets$find_implications()

# Read a formal context from CSV
filename <- system.file("contexts", "airlines.csv", package = "fcaR")
fc <- FormalContext$new(filename)

# Read a formal context from a CXT file
filename <- system.file("contexts", "lives_in_water.cxt", package = "fcaR")
fc <- FormalContext$new(filename)


## ------------------------------------------------
## Method `FormalContext$scale`
## ------------------------------------------------

filename <- system.file("contexts", "aromatic.csv", package = "fcaR")
fc <- FormalContext$new(filename)
fc$scale("nitro", "ordinal", comparison = `>=`, values = 1:3)
fc$scale("OS", "nominal", c("O", "S"))
fc$scale(attributes = "ring", type = "nominal")

## ------------------------------------------------
## Method `FormalContext$get_scales`
## ------------------------------------------------

filename <- system.file("contexts", "aromatic.csv", package = "fcaR")
fc <- FormalContext$new(filename)
fc$scale("nitro", "ordinal", comparison = `>=`, values = 1:3)
fc$scale("OS", "nominal", c("O", "S"))
fc$scale(attributes = "ring", type = "nominal")
fc$get_scales()

## ------------------------------------------------
## Method `FormalContext$background_knowledge`
## ------------------------------------------------

filename <- system.file("contexts", "aromatic.csv", package = "fcaR")
fc <- FormalContext$new(filename)
fc$scale("nitro", "ordinal", comparison = `>=`, values = 1:3)
fc$scale("OS", "nominal", c("O", "S"))
fc$scale(attributes = "ring", type = "nominal")
fc$background_knowledge()

## ------------------------------------------------
## Method `FormalContext$incidence`
## ------------------------------------------------

fc <- FormalContext$new(planets)
fc$incidence()
}
\references{
Guigues J, Duquenne V (1986). “Familles minimales d'implications informatives résultant d'un tableau de données binaires.” \emph{Mathématiques et Sciences humaines}, \emph{95}, 5-18.

Ganter B, Wille R (1999). \emph{Formal concept analysis : mathematical foundations}. Springer. ISBN 3540627715.

Belohlavek R (2002). “Algorithms for fuzzy concept lattices.” In \emph{Proc. Fourth Int. Conf. on Recent Advances in Soft Computing}. Nottingham, United Kingdom, 200-205.

Hahsler M, Grun B, Hornik K (2005). “arules - a computational environment for mining association rules and frequent item sets.” \emph{J Stat Softw}, \emph{14}, 1-25.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{I}}{The table of the formal context as a matrix.}

\item{\code{attributes}}{The attributes of the formal context.}

\item{\code{objects}}{The objects of the formal context.}

\item{\code{grades_set}}{The set of degrees (in [0, 1]) the whole set of attributes can take.}

\item{\code{expanded_grades_set}}{The set of degrees (in [0, 1]) each attribute can take.}

\item{\code{concepts}}{The concept lattice associated to the formal context as a \code{\link{ConceptLattice}}.}

\item{\code{implications}}{A set of implications on the formal context as an \code{\link{ImplicationSet}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FormalContext-new}{\code{FormalContext$new()}}
\item \href{#method-FormalContext-is_empty}{\code{FormalContext$is_empty()}}
\item \href{#method-FormalContext-scale}{\code{FormalContext$scale()}}
\item \href{#method-FormalContext-get_scales}{\code{FormalContext$get_scales()}}
\item \href{#method-FormalContext-background_knowledge}{\code{FormalContext$background_knowledge()}}
\item \href{#method-FormalContext-dual}{\code{FormalContext$dual()}}
\item \href{#method-FormalContext-intent}{\code{FormalContext$intent()}}
\item \href{#method-FormalContext-uparrow}{\code{FormalContext$uparrow()}}
\item \href{#method-FormalContext-extent}{\code{FormalContext$extent()}}
\item \href{#method-FormalContext-downarrow}{\code{FormalContext$downarrow()}}
\item \href{#method-FormalContext-closure}{\code{FormalContext$closure()}}
\item \href{#method-FormalContext-obj_concept}{\code{FormalContext$obj_concept()}}
\item \href{#method-FormalContext-att_concept}{\code{FormalContext$att_concept()}}
\item \href{#method-FormalContext-is_concept}{\code{FormalContext$is_concept()}}
\item \href{#method-FormalContext-is_closed}{\code{FormalContext$is_closed()}}
\item \href{#method-FormalContext-clarify}{\code{FormalContext$clarify()}}
\item \href{#method-FormalContext-reduce}{\code{FormalContext$reduce()}}
\item \href{#method-FormalContext-standardize}{\code{FormalContext$standardize()}}
\item \href{#method-FormalContext-find_concepts}{\code{FormalContext$find_concepts()}}
\item \href{#method-FormalContext-find_implications}{\code{FormalContext$find_implications()}}
\item \href{#method-FormalContext-to_transactions}{\code{FormalContext$to_transactions()}}
\item \href{#method-FormalContext-save}{\code{FormalContext$save()}}
\item \href{#method-FormalContext-load}{\code{FormalContext$load()}}
\item \href{#method-FormalContext-dim}{\code{FormalContext$dim()}}
\item \href{#method-FormalContext-print}{\code{FormalContext$print()}}
\item \href{#method-FormalContext-to_latex}{\code{FormalContext$to_latex()}}
\item \href{#method-FormalContext-incidence}{\code{FormalContext$incidence()}}
\item \href{#method-FormalContext-plot}{\code{FormalContext$plot()}}
\item \href{#method-FormalContext-clone}{\code{FormalContext$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-new"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-new}{}}}
\subsection{Method \code{new()}}{
Creator for the Formal Context class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$new(I, filename, remove_const = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{I}}{(numeric matrix) The table of the formal context.}

\item{\code{filename}}{(character) Path of a file to import.}

\item{\code{remove_const}}{(logical) If \code{TRUE}, remove constant columns. The default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Columns of \code{I} should be named, since they are the names of the attributes of the formal context.

If no \code{I} is used, the resulting \code{FormalContext} will be empty and not usable unless for loading a previously saved one. In this case, one can provide a \code{filename} to import. Only RDS, CSV and CXT files are currently supported.
}

\subsection{Returns}{
An object of the \code{FormalContext} class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Check if the \code{FormalContext} is empty
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the \code{FormalContext} is empty, that is, has not been provided with a matrix, and \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-scale"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-scale}{}}}
\subsection{Method \code{scale()}}{
Scale the context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$scale(attributes, type, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attributes}}{The attributes to scale}

\item{\code{type}}{Type of scaling.}

\item{\code{...}}{}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The types of scaling are implemented in a registry,
so that \code{scalingRegistry$get_entries()} returns
all types.
}

\subsection{Returns}{
The scaled formal context
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{filename <- system.file("contexts", "aromatic.csv", package = "fcaR")
fc <- FormalContext$new(filename)
fc$scale("nitro", "ordinal", comparison = `>=`, values = 1:3)
fc$scale("OS", "nominal", c("O", "S"))
fc$scale(attributes = "ring", type = "nominal")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-get_scales"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-get_scales}{}}}
\subsection{Method \code{get_scales()}}{
Scales applied to the formal context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$get_scales(attributes = names(private$scales))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attributes}}{(character) Name of the attributes for which scales
(if applied) are returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The scales that have been applied to the specified attributes
of the formal context. If no \code{attributes} are passed,
then all applied scales are returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{filename <- system.file("contexts", "aromatic.csv", package = "fcaR")
fc <- FormalContext$new(filename)
fc$scale("nitro", "ordinal", comparison = `>=`, values = 1:3)
fc$scale("OS", "nominal", c("O", "S"))
fc$scale(attributes = "ring", type = "nominal")
fc$get_scales()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-background_knowledge"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-background_knowledge}{}}}
\subsection{Method \code{background_knowledge()}}{
Background knowledge of a scaled formal context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$background_knowledge()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{ImplicationSet} with the implications
extracted from the application of scales.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{filename <- system.file("contexts", "aromatic.csv", package = "fcaR")
fc <- FormalContext$new(filename)
fc$scale("nitro", "ordinal", comparison = `>=`, values = 1:3)
fc$scale("OS", "nominal", c("O", "S"))
fc$scale(attributes = "ring", type = "nominal")
fc$background_knowledge()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-dual"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-dual}{}}}
\subsection{Method \code{dual()}}{
Get the dual formal context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$dual()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{FormalContext} where objects and attributes have interchanged their roles.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-intent"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-intent}{}}}
\subsection{Method \code{intent()}}{
Get the intent of a fuzzy set of objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$intent(S)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(\code{Set}) The set of objects to compute the intent for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Set} with the intent.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-uparrow"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-uparrow}{}}}
\subsection{Method \code{uparrow()}}{
Get the intent of a fuzzy set of objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$uparrow(S)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(\code{Set}) The set of objects to compute the intent for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Set} with the intent.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-extent"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-extent}{}}}
\subsection{Method \code{extent()}}{
Get the extent of a fuzzy set of attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$extent(S)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(\code{Set}) The set of attributes to compute the extent for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Set} with the intent.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-downarrow"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-downarrow}{}}}
\subsection{Method \code{downarrow()}}{
Get the extent of a fuzzy set of attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$downarrow(S)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(\code{Set}) The set of attributes to compute the extent for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Set} with the intent.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-closure"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-closure}{}}}
\subsection{Method \code{closure()}}{
Get the closure of a fuzzy set of attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$closure(S)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(\code{Set}) The set of attributes to compute the closure for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Set} with the closure.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-obj_concept"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-obj_concept}{}}}
\subsection{Method \code{obj_concept()}}{
Object Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$obj_concept(object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object}}{(character) Name of the object to compute its associated concept}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object concept associated to the object given.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-att_concept"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-att_concept}{}}}
\subsection{Method \code{att_concept()}}{
Attribute Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$att_concept(attribute)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attribute}}{(character) Name of the attribute to compute its associated concept}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The attribute concept associated to the attribute given.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-is_concept"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-is_concept}{}}}
\subsection{Method \code{is_concept()}}{
Is a Concept?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$is_concept(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{A \code{Concept} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if \code{C} is a concept.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-is_closed"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-is_closed}{}}}
\subsection{Method \code{is_closed()}}{
Testing closure of attribute sets
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$is_closed(S)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{A \code{Set} of attributes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the set \code{S} is closed in this formal context.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-clarify"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-clarify}{}}}
\subsection{Method \code{clarify()}}{
Clarify a formal context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$clarify(copy = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{copy}}{(logical) If \code{TRUE}, a new \code{FormalContext} object is created with the clarified context, otherwise the current one is overwritten.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The clarified \code{FormalContext}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-reduce"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-reduce}{}}}
\subsection{Method \code{reduce()}}{
Reduce a formal context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$reduce(copy = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{copy}}{(logical) If \code{TRUE}, a new \code{FormalContext} object is created with the clarified and reduced context, otherwise the current one is overwritten.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The clarified and reduced \code{FormalContext}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-standardize"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-standardize}{}}}
\subsection{Method \code{standardize()}}{
Build the Standard Context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$standardize()}\if{html}{\out{</div>}}
}

\subsection{Details}{
All concepts must be previously computed.
}

\subsection{Returns}{
The standard context using the join- and meet- irreducible elements.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-find_concepts"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-find_concepts}{}}}
\subsection{Method \code{find_concepts()}}{
Use Ganter Algorithm to compute concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$find_concepts(verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{(logical) TRUE will provide a verbose output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with all the concepts in the formal context.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-find_implications"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-find_implications}{}}}
\subsection{Method \code{find_implications()}}{
Use modified Ganter algorithm to compute both concepts and implications
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$find_implications(save_concepts = TRUE, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{save_concepts}}{(logical) \code{TRUE} will also compute and save the concept lattice. \code{FALSE} is usually faster, since it only computes implications.}

\item{\code{verbose}}{(logical) \code{TRUE} will provide a verbose output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, just updates the internal fields \code{concepts} and \code{implications}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-to_transactions"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-to_transactions}{}}}
\subsection{Method \code{to_transactions()}}{
Convert the formal context to object of class \code{transactions} from the \code{arules} package
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$to_transactions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{transactions} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-save"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-save}{}}}
\subsection{Method \code{save()}}{
Save a \code{FormalContext} to RDS or CXT format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$save(filename = tempfile(fileext = ".rds"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{(character) Path of the  file where to store the \code{FormalContext}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The format is inferred from the extension of the filename.
}

\subsection{Returns}{
Invisibly the current \code{FormalContext}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-load"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-load}{}}}
\subsection{Method \code{load()}}{
Load a \code{FormalContext} from a file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$load(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{(character) Path of the file to load the \code{FormalContext} from.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Currently, only RDS, CSV and CXT files are supported.
}

\subsection{Returns}{
The loaded \code{FormalContext}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-dim"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-dim}{}}}
\subsection{Method \code{dim()}}{
Dimensions of the formal context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$dim()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with (number of objects, number of attributes).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-print"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-print}{}}}
\subsection{Method \code{print()}}{
Prints the formal context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Prints information regarding the formal context.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Write the context in LaTeX format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$to_latex(
  table = TRUE,
  label = "",
  caption = "",
  fraction = c("none", "frac", "dfrac", "sfrac")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{(logical) If \code{TRUE}, surrounds everything between \code{\\begin{table}} and \code{\\end{table}}.}

\item{\code{label}}{(character) The label for the table environment.}

\item{\code{caption}}{(character) The caption of the table.}

\item{\code{fraction}}{(character) If \code{none}, no fractions are produced. Otherwise, if it is \code{frac}, \code{dfrac} or \code{sfrac}, decimal numbers are represented as fractions with the corresponding LaTeX typesetting.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A table environment in LaTeX.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-incidence"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-incidence}{}}}
\subsection{Method \code{incidence()}}{
Incidence matrix of the formal context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$incidence()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The incidence matrix of the formal context
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fc <- FormalContext$new(planets)
fc$incidence()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-plot"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the formal context table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$plot(to_latex = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{to_latex}}{(logical) If \code{TRUE}, export the plot as a \code{tikzpicture} environment that can be included in a \code{LaTeX} file.}

\item{\code{...}}{Other parameters to be passed to the \code{tikzDevice} that renders the lattice in \code{LaTeX}, or for the figure caption. See \code{Details}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Particular parameters that control the size of the \code{tikz} output are: \code{width}, \code{height} (both in inches), and \code{pointsize} (in points), that should be set to the font size used in the \code{documentclass} header in the \code{LaTeX} file where the code is to be inserted.

If a \code{caption} is provided, the whole \code{tikz} picture will be wrapped by a \code{figure} environment and the caption set.
}

\subsection{Returns}{
If \code{to_latex} is \code{FALSE}, it returns nothing, just plots the graph of the formal context. Otherwise, this function returns the \code{LaTeX} code to reproduce the formal context plot.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormalContext-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FormalContext-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormalContext$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
