% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faviconPlease.R
\name{faviconIco}
\alias{faviconIco}
\title{Check for the existence of favicon.ico}
\usage{
faviconIco(
  scheme,
  server,
  path,
  method = getOption("download.file.method", default = "auto"),
  extra = getOption("download.file.extra"),
  headers = NULL
)
}
\arguments{
\item{scheme}{"http" or "https"}

\item{server}{The name of the server, e.g. "www.r-project.org"}

\item{path}{The path to a target file on the server (must start with a
forward slash)}

\item{method}{Method to be used for downloading files.  Current
    download methods are \code{"internal"}, \code{"libcurl"},
    \code{"wget"}, \code{"curl"} and \code{"wininet"} (Windows
    only), and there is a value \code{"auto"}: see \sQuote{Details} and
    \sQuote{Note}.

    The method can also be set through the option
    \code{"download.file.method"}: see \code{\link{options}()}.
  }

\item{extra}{character vector of additional command-line arguments for
    the \code{"wget"} and \code{"curl"} methods.}

\item{headers}{named character vector of additional HTTP headers to
    use in HTTP[S] requests.  It is ignored for non-HTTP[S] URLs.  The
    \code{User-Agent} header taken from the \code{HTTPUserAgent} option
    (see \code{\link{options}}) is automatically used as the first header.}
}
\value{
URL to \code{favicon.ico} or \code{""}.
}
\description{
Check for the existence of favicon.ico
}
\seealso{
\code{\link{faviconPlease}},
         \code{\link{faviconLink}}
}
